/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.scheduledtask.util;

import com.suncode.plugin.tools.scheduledtask.util.EncryptionDecryptionTaskConfig;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.springframework.stereotype.Component;

@Component
public class Validation {
    private static final int MIN_NUMBERS_OF_THREADS = 1;
    private static final int MAX_NUMBER_OF_THREADS = 50;

    public void validNThreads(Long nThreads) {
        if (nThreads < 1L || nThreads > 50L) {
            throw new IllegalArgumentException("The parameter 'nThreads' must be between 1 and 50");
        }
    }

    public void validDocumentClass(EncryptionDecryptionTaskConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getCipherAlgorithm()) || config.getKeyLength() == null || config.getKeyLength() < 1L) {
            throw new IllegalArgumentException("The document  class " + config.getDocClass().getName() + " has no encryption parameters set");
        }
    }

    public void validDateRange(LocalDate fromFileCreationDate, LocalDate toFileCreationDate) {
        if (fromFileCreationDate.compareTo((ReadablePartial)toFileCreationDate) > 0) {
            throw new IllegalArgumentException("Invalid date parameters. From: " + fromFileCreationDate + " To: " + toFileCreationDate);
        }
    }
}

