/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.scheduledtask.dto;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.WfFile;
import java.beans.ConstructorProperties;

public class WfFileDto {
    private long id;
    private String fileName;
    private String fullPath;
    private String systemFileName;
    private long documentClassId;
    private String documentClassName;
    private String cipherAlgorithm;
    private String cipherKey;

    public WfFileDto(WfFile wfFile) {
        this.id = wfFile.getId();
        this.fileName = wfFile.getFileName();
        this.fullPath = wfFile.getFullPath();
        this.systemFileName = wfFile.getSystemFileName();
        DocumentClass documentClass = wfFile.getDocumentClass();
        if (documentClass != null) {
            this.documentClassId = documentClass.getId();
            this.documentClassName = documentClass.getName();
        }
        this.cipherAlgorithm = wfFile.getCipherAlgorithm();
        this.cipherKey = wfFile.getCipherKey();
    }

    public static WfFileDtoBuilder builder() {
        return new WfFileDtoBuilder();
    }

    public long getId() {
        return this.id;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    public String getSystemFileName() {
        return this.systemFileName;
    }

    public long getDocumentClassId() {
        return this.documentClassId;
    }

    public String getDocumentClassName() {
        return this.documentClassName;
    }

    public String getCipherAlgorithm() {
        return this.cipherAlgorithm;
    }

    public String getCipherKey() {
        return this.cipherKey;
    }

    @ConstructorProperties(value={"id", "fileName", "fullPath", "systemFileName", "documentClassId", "documentClassName", "cipherAlgorithm", "cipherKey"})
    public WfFileDto(long id, String fileName, String fullPath, String systemFileName, long documentClassId, String documentClassName, String cipherAlgorithm, String cipherKey) {
        this.id = id;
        this.fileName = fileName;
        this.fullPath = fullPath;
        this.systemFileName = systemFileName;
        this.documentClassId = documentClassId;
        this.documentClassName = documentClassName;
        this.cipherAlgorithm = cipherAlgorithm;
        this.cipherKey = cipherKey;
    }

    public static class WfFileDtoBuilder {
        private long id;
        private String fileName;
        private String fullPath;
        private String systemFileName;
        private long documentClassId;
        private String documentClassName;
        private String cipherAlgorithm;
        private String cipherKey;

        WfFileDtoBuilder() {
        }

        public WfFileDtoBuilder id(long id) {
            this.id = id;
            return this;
        }

        public WfFileDtoBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public WfFileDtoBuilder fullPath(String fullPath) {
            this.fullPath = fullPath;
            return this;
        }

        public WfFileDtoBuilder systemFileName(String systemFileName) {
            this.systemFileName = systemFileName;
            return this;
        }

        public WfFileDtoBuilder documentClassId(long documentClassId) {
            this.documentClassId = documentClassId;
            return this;
        }

        public WfFileDtoBuilder documentClassName(String documentClassName) {
            this.documentClassName = documentClassName;
            return this;
        }

        public WfFileDtoBuilder cipherAlgorithm(String cipherAlgorithm) {
            this.cipherAlgorithm = cipherAlgorithm;
            return this;
        }

        public WfFileDtoBuilder cipherKey(String cipherKey) {
            this.cipherKey = cipherKey;
            return this;
        }

        public WfFileDto build() {
            return new WfFileDto(this.id, this.fileName, this.fullPath, this.systemFileName, this.documentClassId, this.documentClassName, this.cipherAlgorithm, this.cipherKey);
        }

        public String toString() {
            return "WfFileDto.WfFileDtoBuilder(id=" + this.id + ", fileName=" + this.fileName + ", fullPath=" + this.fullPath + ", systemFileName=" + this.systemFileName + ", documentClassId=" + this.documentClassId + ", documentClassName=" + this.documentClassName + ", cipherAlgorithm=" + this.cipherAlgorithm + ", cipherKey=" + this.cipherKey + ")";
        }
    }
}

