/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.savefile.support;

import com.suncode.plugin.tools.savefile.dto.FileToSaveDto;
import com.suncode.plugin.tools.savefile.hook.DestinationFileHook;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.core.function.FunctionCall;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RenamingFileNames {
    private List<FileToSaveDto> destinationFileNames;

    public List<FileToSaveDto> getDestinationFileNames(DestinationFileHook hook, FunctionCall fileName, List<WfFile> fileList) {
        this.destinationFileNames = fileList.stream().map(file -> {
            String originalFileName = file.getFileName();
            hook.update(originalFileName);
            String modifiedFileName = fileName != null ? (String)fileName.call() : originalFileName;
            return FileToSaveDto.builder().id(file.getId()).name(modifiedFileName).build();
        }).collect(Collectors.toList());
        this.changeFileNameIfDuplicated();
        return this.destinationFileNames;
    }

    private void changeFileNameIfDuplicated() {
        boolean isFileNameDuplicated = this.destinationFileNames.stream().collect(Collectors.groupingBy(FileToSaveDto::getName, Collectors.counting())).entrySet().stream().anyMatch(value -> (Long)value.getValue() > 1L);
        if (isFileNameDuplicated) {
            this.changeFileName();
        }
    }

    private void changeFileName() {
        LinkedHashSet fileNameSet = new LinkedHashSet();
        this.destinationFileNames = this.destinationFileNames.stream().map(file -> this.changeToUniqueFileName((FileToSaveDto)file, fileNameSet)).collect(Collectors.toList());
    }

    private FileToSaveDto changeToUniqueFileName(FileToSaveDto file, Set<String> fileNameSet) {
        String fileName;
        String value = fileName = file.getName();
        int i = 1;
        while (!fileNameSet.add(value)) {
            value = this.addDigitToExistingFile(i, fileName);
            ++i;
        }
        return FileToSaveDto.builder().id(file.getId()).name(value).build();
    }

    private String addDigitToExistingFile(int digit, String fileName) {
        CharSequence[] fileNameParts = fileName.split("\\.");
        if (fileNameParts.length == 1 || fileNameParts.length == 2 && StringUtils.isBlank((CharSequence)fileNameParts[0])) {
            int n = fileNameParts.length - 1;
            fileNameParts[n] = fileNameParts[n] + " (" + digit + ")";
        } else {
            int n = fileNameParts.length - 2;
            fileNameParts[n] = fileNameParts[n] + " (" + digit + ")";
        }
        return String.join((CharSequence)".", fileNameParts);
    }
}

