/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.email;

import com.suncode.plugin.tools.email.EmailEngine;
import com.suncode.plugin.tools.email.dto.SendReportDto;
import com.suncode.pwfl.administration.email.EmailAttachment;
import com.suncode.pwfl.administration.email.EmailMessage;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmailHelper {
    @Autowired
    private EmailEngine emailEngine;

    public List<EmailAttachment> createEmailAttachments(String documentSource, ActivityContextMap activityContextMap, Map<String, String> docClassAndPrefix, Map<String, String> docClassAndFileNameRegexp, String[] fileIds) {
        if (documentSource.equalsIgnoreCase("documentClass")) {
            return this.emailEngine.addDocumentFromProcess(activityContextMap, docClassAndPrefix, docClassAndFileNameRegexp);
        }
        return this.emailEngine.addDocumentFromProcessWithFileId(activityContextMap, Arrays.asList(fileIds));
    }

    public void sendEmail(EmailConfiguration emailConfiguration, EmailMessage message, List<String> recipients, List<String> copyRecipients, List<String> hiddenCopyRecipients, SendReportDto report, Boolean addAttachments, String documentSource, ActivityContextMap activityContextMap, Map<String, String> docClassAndPrefix, Map<String, String> docClassAndFileNameRegexp, String[] fileIds, Boolean isFirstEmail) {
        EmailMessage.EmailMessageBuilder builder = EmailMessage.builder().recipients(recipients).copyRecipients(copyRecipients).hiddenCopyRecipients(hiddenCopyRecipients).subject(message.getSubject()).content(message.getContent()).isHtml(true);
        if (message.getParams() != null) {
            builder.params(message.getParams());
        }
        if (Boolean.TRUE.equals(addAttachments)) {
            if (isFirstEmail == null || isFirstEmail.booleanValue()) {
                builder.attachments((Collection)message.getAttachments());
            } else {
                List<EmailAttachment> emailAttachments = this.createEmailAttachments(documentSource, activityContextMap, docClassAndPrefix, docClassAndFileNameRegexp, fileIds);
                builder.attachments(emailAttachments);
            }
        }
        EmailMessage emailMessage = builder.build();
        this.emailEngine.sendMail(emailConfiguration, emailMessage, recipients, report);
    }

    public void sendEmail(EmailConfiguration emailConfiguration, EmailMessage message, List<String> recipients, List<String> copyRecipients, List<String> hiddenCopyRecipients, SendReportDto report, Boolean addAttachments) {
        this.sendEmail(emailConfiguration, message, recipients, copyRecipients, hiddenCopyRecipients, report, addAttachments, null, null, null, null, null, null);
    }
}

