/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.email;

import com.google.common.base.Strings;
import com.plusmpm.database.DocumentTemplateTable;
import com.suncode.cuf.mail.Addresses;
import com.suncode.cuf.mail.MailConfiguration;
import com.suncode.cuf.mail.MailContent;
import com.suncode.cuf.mail.SendReport;
import com.suncode.cuf.mail.SimpleMailContent;
import com.suncode.plugin.tools.docutils.DocUtils;
import com.suncode.plugin.tools.email.EmailEngine;
import com.suncode.plugin.tools.email.dto.AddressesDto;
import com.suncode.plugin.tools.email.dto.DocumentAttachment;
import com.suncode.plugin.tools.email.dto.DocumentAttachmentInfo;
import com.suncode.plugin.tools.email.dto.FileAttachment;
import com.suncode.plugin.tools.email.dto.SendReportDto;
import com.suncode.plugin.tools.until.CreatorSettings;
import com.suncode.plugin.tools.until.FileTools;
import com.suncode.plugin.tools.until.Formatter;
import com.suncode.plugin.tools.until.TranslatorWrapper;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.email.EmailAttachment;
import com.suncode.pwfl.administration.email.EmailMessage;
import com.suncode.pwfl.administration.email.EmailService;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentTemplateService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.util.TempFile;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityEntity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.archiver.ZipArchiverManager;
import com.suncode.pwfl.workflow.cipher.CipherManager;
import com.suncode.pwfl.workflow.process.Comment;
import com.suncode.pwfl.workflow.process.CommentService;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.process.ProcessIndex;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="emailEngineService")
public class EmailEngineImpl
implements EmailEngine {
    private static final Logger log = LoggerFactory.getLogger(EmailEngineImpl.class);
    private static final int COMMENT_MAX_LENGTH = 4000;
    private static final int ERROR_DESCRIPTION_MAX_LENGTH = 250;
    private static final String START_ROWS_TAG = "@@rows@@";
    private static final String END_ROWS_TAG = "@@end_rows@@";
    private static final Pattern TAG_PATTERN = Pattern.compile("@(\\w+)@");
    @Autowired
    private CommentService commentService;
    @Autowired
    private DocumentTemplateService docTemplateService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private ProcessService processService;
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private UserService userService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private DocUtils docUtils;
    @Autowired
    private FileFinder fileFinder;
    @Autowired
    private TranslatorWrapper translator;
    @Autowired
    private EmailService emailService;

    @Override
    public void sendMail(EmailConfiguration emailConfiguration, EmailMessage emailMessage, List<String> recipients, SendReportDto report) {
        try {
            this.emailService.send(emailMessage, emailConfiguration);
            report.getSuccessfulEmails().addAll(recipients);
        }
        catch (Exception e) {
            String exceptionMessage = this.getExceptionMessage(e);
            log.warn(exceptionMessage, (Throwable)e);
            report.getFailedEmails().addAll(recipients);
            report.getErrors().put(recipients.toString(), this.parseErrorDescription(exceptionMessage));
        }
    }

    private String decompressFile(WfFile wfFile, AtomicBoolean isTemp) {
        if (wfFile.isCompressed() || wfFile.isEncrypted()) {
            try {
                InputStream inputStream = new FileInputStream(wfFile.getFullPath());
                inputStream = ZipArchiverManager.uncompress((InputStream)inputStream, (WfFile)wfFile);
                inputStream = CipherManager.decryptFile((InputStream)inputStream, (WfFile)wfFile);
                TempFile tempFile = new TempFile();
                FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile.getFile());
                isTemp.set(true);
                return tempFile.getFile().getAbsolutePath();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return wfFile.getFullPath();
    }

    @Override
    public List<EmailAttachment> addDocumentFromProcess(ActivityContextMap activityContextMap, Map<String, String> docClassAndPrefix, Map<String, String> docClassAndFileNameRegexp) {
        List<DocumentAttachmentInfo> documentAttachmentInfos = this.builtAttachmentInfosSourceFromDocumentClass(docClassAndPrefix, docClassAndFileNameRegexp);
        if (!documentAttachmentInfos.isEmpty()) {
            List<DocumentAttachment> documents = this.getDocumentsFromProcessWithDocumentClass(documentAttachmentInfos, activityContextMap);
            return documents.stream().map(documentAttachment -> {
                AtomicBoolean isTemp = new AtomicBoolean(false);
                File decompressedFile = new File(this.decompressFile(documentAttachment.getWfDocument().getFile(), isTemp));
                return EmailAttachment.builder().file(decompressedFile).filename(documentAttachment.getAttachmentName()).temp(isTemp.get()).build();
            }).collect(Collectors.toList());
        }
        List documents = this.documentFinder.getDocumentsFromProcess(activityContextMap.getProcessId(), new String[]{"documentClass"});
        return documents.stream().map(wfDocument -> {
            AtomicBoolean isTemp = new AtomicBoolean(false);
            File decompressedFile = new File(this.decompressFile(wfDocument.getFile(), isTemp));
            return EmailAttachment.builder().file(decompressedFile).filename(wfDocument.getFile().getFileName()).temp(isTemp.get()).build();
        }).sorted(Comparator.comparing(EmailAttachment::getFilename)).collect(Collectors.toList());
    }

    @Override
    public List<EmailAttachment> addDocumentFromProcessWithFileId(ActivityContextMap activityContextMap, List<String> fileIds) {
        List<FileAttachment> filesFromProcessWithFileId = this.getFilesFromProcessWithFileId(activityContextMap, fileIds);
        return filesFromProcessWithFileId.stream().map(fileAttachment -> {
            AtomicBoolean isTemp = new AtomicBoolean(false);
            File decompressedFile = new File(this.decompressFile(fileAttachment.getWfFile(), isTemp));
            return EmailAttachment.builder().file(decompressedFile).filename(fileAttachment.getAttachmentName()).temp(isTemp.get()).build();
        }).collect(Collectors.toList());
    }

    public List<FileAttachment> getFilesFromProcessWithFileId(ActivityContextMap activityContextMap, List<String> fileIds) {
        List<DocumentAttachmentInfo> documentAttachmentInfos = this.builtAttachmentInfosSourceFromFileId(fileIds);
        ArrayList<List> allFilesVersionFromProcess = new ArrayList<List>();
        for (WfFile file : this.getAllFilesVersionFromProcess(activityContextMap.getProcessId())) {
            allFilesVersionFromProcess.add(this.fileFinder.getAllVersionsForFile(Long.valueOf(file.getId())));
        }
        ArrayList<FileAttachment> fileAttachmentList = new ArrayList<FileAttachment>();
        for (List fileFromProcess : allFilesVersionFromProcess) {
            List fileAttachments = documentAttachmentInfos.stream().map(documentAttachmentInfo -> this.createFileAttachments(fileFromProcess, (DocumentAttachmentInfo)documentAttachmentInfo)).flatMap(Collection::stream).collect(Collectors.toList());
            fileAttachmentList.addAll(fileAttachments);
        }
        return fileAttachmentList;
    }

    public List<FileAttachment> createFileAttachments(List<WfFileVersion> fileVersions, DocumentAttachmentInfo documentAttachmentInfo) {
        return fileVersions.stream().filter(wfFileVersion -> wfFileVersion.getFile().getId() == documentAttachmentInfo.getFileId().longValue()).map(wfFileVersion -> {
            String prefix = documentAttachmentInfo.getPrefix();
            Object attachmentName = wfFileVersion.getFile().getFileName();
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                attachmentName = prefix + (String)attachmentName;
            }
            log.info("Attachment name={}", attachmentName);
            return new FileAttachment((String)attachmentName, wfFileVersion.getFile());
        }).collect(Collectors.toList());
    }

    @Override
    public void logSendReport(SendReportDto sendReport) {
        this.logReport(sendReport.getFailedEmails(), sendReport.getSuccessfulEmails());
    }

    private void logReport(List<String> failedEmails, List<String> successfulEmails) {
        if (CollectionUtils.isNotEmpty(successfulEmails)) {
            log.info("Successfully sent to recipients: " + Arrays.toString(successfulEmails.toArray()));
        }
        if (CollectionUtils.isNotEmpty(failedEmails)) {
            log.info("Failed to send to recipients: " + Arrays.toString(failedEmails.toArray()));
        }
    }

    @Override
    public void commentResult(ActivityContextMap activityContextMap, SendReportDto sendReportDto, AddressesDto addressesDto) {
        List<String> successEmails = sendReportDto.getSuccessfulEmails();
        List<String> failedEmails = sendReportDto.getFailedEmails();
        List<String> invalidDirectAddresses = addressesDto.getDirectAddresses().getInvalidAddresses();
        List<String> invalidCopyAddresses = addressesDto.getCopyAddresses().getInvalidAddresses();
        List<String> invalidHiddenCopyAddresses = addressesDto.getHiddenCopyAddresses().getInvalidAddresses();
        if (CollectionUtils.isNotEmpty(invalidDirectAddresses) || CollectionUtils.isNotEmpty(invalidCopyAddresses) || CollectionUtils.isNotEmpty(invalidHiddenCopyAddresses)) {
            StringBuilder message = new StringBuilder(this.translator.getMessage("errors.invalidAddresses"));
            if (CollectionUtils.isNotEmpty(invalidDirectAddresses)) {
                message.append(System.lineSeparator()).append(this.translator.getMessage("errors.invalidDirectAddresses", invalidDirectAddresses.toString()));
            }
            if (CollectionUtils.isNotEmpty(invalidCopyAddresses)) {
                message.append(System.lineSeparator()).append(this.translator.getMessage("errors.invalidCopyAddresses", invalidCopyAddresses.toString()));
            }
            if (CollectionUtils.isNotEmpty(invalidHiddenCopyAddresses)) {
                message.append(System.lineSeparator()).append(this.translator.getMessage("errors.invalidHiddenCopyAddresses", invalidHiddenCopyAddresses.toString()));
            }
            this.addComment(message.toString(), activityContextMap);
        }
        if (CollectionUtils.isNotEmpty(successEmails)) {
            this.addComment(this.translator.getMessage("info.emailsSentSuccessfully", successEmails.toString()), activityContextMap);
        }
        if (CollectionUtils.isNotEmpty(failedEmails)) {
            Map<String, String> errors = sendReportDto.getErrors();
            String errorsDescription = errors.keySet().stream().map(email -> "(" + email + " -> " + (String)errors.get(email) + ")").collect(Collectors.joining("," + System.lineSeparator()));
            String message = this.translator.getMessage("errors.failedToSendEmails", failedEmails.toString()) + System.lineSeparator() + this.translator.getMessage("errors.failedToSendEmailsDescription", errorsDescription);
            this.addComment(message, activityContextMap);
        }
    }

    @Override
    public File getContentHtml(EmailConfiguration cfg, EmailMessage emailMessage, AddressesDto addressesDto, Boolean isHeader, String customHeaderTemplatePath) {
        Document doc = Jsoup.parse((String)"<html></html>");
        if (Boolean.TRUE.equals(isHeader)) {
            doc = this.loadTemplate(doc, customHeaderTemplatePath);
            List<String> directAddresses = addressesDto.getDirectAddresses().getValidAddresses();
            List<String> copyAddresses = addressesDto.getCopyAddresses().getValidAddresses();
            List<String> hiddenCopyAddresses = addressesDto.getHiddenCopyAddresses().getValidAddresses();
            this.fillTemplateValues(doc, cfg.getMailUser(), emailMessage, directAddresses, copyAddresses, hiddenCopyAddresses);
        } else {
            doc.body().append(emailMessage.getContent());
        }
        return this.createTempFile(doc);
    }

    public List<DocumentAttachment> getDocumentsFromProcessWithDocumentClass(List<DocumentAttachmentInfo> documentAttachmentInfos, ActivityContextMap activityContextMap) {
        return documentAttachmentInfos.stream().map(documentAttachmentInfo -> this.getDocumentsFromProcessAndDocumentClass(activityContextMap, (DocumentAttachmentInfo)documentAttachmentInfo)).flatMap(Collection::stream).sorted(Comparator.comparing(documentAttachment -> documentAttachment.getWfDocument().getFile().getFileName())).collect(Collectors.toList());
    }

    public List<DocumentAttachment> getDocumentsFromProcessAndDocumentClass(ActivityContextMap activityContextMap, DocumentAttachmentInfo documentAttachmentInfo) {
        return this.documentFinder.getDocumentsFromProcessAndClass(activityContextMap.getProcessId(), documentAttachmentInfo.getDocumentClassName(), new String[]{"documentClass"}).stream().filter(wfDocument -> StringUtils.isBlank((CharSequence)documentAttachmentInfo.getFileNameRegexp()) || wfDocument.getFile().getFileName().matches(documentAttachmentInfo.getFileNameRegexp())).map(wfDocument -> {
            String prefix = documentAttachmentInfo.getPrefix();
            Object attachmentName = wfDocument.getFile().getFileName();
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                attachmentName = prefix + (String)attachmentName;
            }
            return new DocumentAttachment((String)attachmentName, (WfDocument)wfDocument);
        }).collect(Collectors.toList());
    }

    private void fillTemplateValues(Document doc, String user, EmailMessage emailMessage, List<String> directAddresses, List<String> copyAddresses, List<String> hiddenCopyAddresses) {
        List<String> attachedFiles = emailMessage.getAttachments().stream().map(EmailAttachment::getFilename).collect(Collectors.toList());
        this.fillTemplateValues(doc, user, emailMessage.getContent(), emailMessage.getSubject(), attachedFiles, directAddresses, copyAddresses, hiddenCopyAddresses);
    }

    private void fillTemplateValues(Document doc, String user, String content, String subject, List<String> attachedFiles, List<String> directAddresses, List<String> copyAddresses, List<String> hiddenCopyAddresses) {
        Elements emailFromEl = doc.getElementsContainingOwnText("@emailFrom@");
        emailFromEl.html(this.buildHtmlSpan(user));
        Elements emailContentEl = doc.getElementsContainingOwnText("@emailContent@");
        emailContentEl.html(content);
        Elements emailSubjectEl = doc.getElementsContainingOwnText("@emailSubject@");
        emailSubjectEl.html(this.buildHtmlSpan(subject));
        Collections.sort(directAddresses);
        Elements emailToEl = doc.getElementsContainingOwnText("@emailTo@");
        emailToEl.html(this.convert2HtmlSpans(directAddresses));
        Collections.sort(copyAddresses);
        Elements emailCopyEl = doc.getElementsContainingOwnText("@emailCopy@");
        emailCopyEl.html(this.convert2HtmlSpans(copyAddresses));
        Collections.sort(hiddenCopyAddresses);
        Elements emailHiddenCopyEl = doc.getElementsContainingOwnText("@emailHiddenCopy@");
        emailHiddenCopyEl.html(this.convert2HtmlSpans(hiddenCopyAddresses));
        Elements emailAttachmentsEl = doc.getElementsContainingOwnText("@emailAttachments@");
        emailAttachmentsEl.html(this.convert2HtmlSpans(attachedFiles));
    }

    @Override
    public void addDocumentFromProcess(SimpleMailContent content, ActivityContextMap activityContextMap, Map<String, String> docClassAndPrefix, Map<String, String> docClassAndFileNameRegexp) {
        List<DocumentAttachmentInfo> documentAttachmentInfos = this.builtAttachmentInfosSourceFromDocumentClass(docClassAndPrefix, docClassAndFileNameRegexp);
        if (!documentAttachmentInfos.isEmpty()) {
            this.addDocumentFromProcessWithDocumentClass(documentAttachmentInfos, content, activityContextMap);
        } else {
            List documents = this.documentFinder.getDocumentsFromProcess(activityContextMap.getProcessId(), new String[]{"documentClass"});
            this.docUtils.sortWfDocumentsByName(documents);
            content.setWfDocuments(documents);
        }
    }

    @Override
    public Optional<String> getTemplatePath(String name, String processDefId) {
        List templateTable = this.docTemplateService.getAllDocumentTemplatesForProcess(processDefId);
        for (DocumentTemplateTable documentTemplateTable : templateTable) {
            if (!documentTemplateTable.getTemplateName().equals(name)) continue;
            return Optional.ofNullable(documentTemplateTable.getTemplatePath());
        }
        return Optional.empty();
    }

    @Override
    public void commentResult(ActivityContextMap activityContextMap, List<String> successEmails, List<String> failedEmails) {
        if (!successEmails.isEmpty()) {
            this.addComment(this.translator.getMessage("info.emailsSentSuccessfully", successEmails.toString()), activityContextMap);
        }
        if (!failedEmails.isEmpty()) {
            this.addComment(this.translator.getMessage("errors.failedToSendEmails", failedEmails.toString()), activityContextMap);
        }
    }

    @Override
    public String replaceExpressions(String sData, ActivityContextMap activityContextMap, UserInfo userInfo) {
        Activity activity = this.activityService.getActivity(activityContextMap.getProcessId(), activityContextMap.getActivityId(), new String[0]);
        Process process = this.processService.getProcess(activityContextMap.getProcessId(), new String[]{"processDefinition"});
        HashMap<String, Object> mapExpressions = new HashMap<String, Object>();
        mapExpressions.put("processname", process.getName());
        mapExpressions.put("processdescription", process.getDescription());
        mapExpressions.put("processdefid", process.getProcessDefinition().getProcessDefinitionId());
        mapExpressions.put("processpackageid", process.getProcessDefinition().getPackageId());
        mapExpressions.put("processstarttime", new SimpleDateFormat("HH:mm").format(process.getCreatedTime()));
        mapExpressions.put("processstartday", new SimpleDateFormat("dd-MM-yyyy").format(process.getCreatedTime()));
        mapExpressions.put("processscreatedtime", new SimpleDateFormat("HH:mm").format(process.getCreatedTime()));
        mapExpressions.put("processcreatedteday", new SimpleDateFormat("dd-MM-yyyy").format(process.getCreatedTime()));
        mapExpressions.put("activityname", activity.getName());
        mapExpressions.put("activitydescription", activity.getDescription());
        mapExpressions.put("activitydefid", activity.getActivityDefinitionId());
        mapExpressions.put("activityid", activity.getActivityId());
        mapExpressions.put("activitystarttime", new SimpleDateFormat("HH:mm").format(activity.getCreatedTime()));
        mapExpressions.put("activitystartday", new SimpleDateFormat("dd-MM-yyyy").format(activity.getCreatedTime()));
        mapExpressions.put("activitycreatedtime", new SimpleDateFormat("HH:mm").format(activity.getCreatedTime()));
        mapExpressions.put("activitycreatedday", new SimpleDateFormat("dd-MM-yyyy").format(activity.getCreatedTime()));
        if (userInfo != null) {
            mapExpressions.put("userfullname", userInfo.getFullName());
            mapExpressions.put("userfirstname", userInfo.getFirstName());
            mapExpressions.put("userlastname", userInfo.getLastName());
            mapExpressions.put("useremail", userInfo.getEmail());
            mapExpressions.put("username", userInfo.getUserName());
            mapExpressions.put("usernumber", userInfo.getNumber());
        } else {
            mapExpressions.put("userfullname", "brak informacji");
            mapExpressions.put("userfirstname", "brak informacji");
            mapExpressions.put("userlastname", "brak informacji");
            mapExpressions.put("useremail", "brak informacji");
            mapExpressions.put("username", "brak informacji");
            mapExpressions.put("usernumber", "brak informacji");
        }
        mapExpressions.putAll(activityContextMap.getVariables());
        mapExpressions.putAll(this.getTaskUsers(sData, process.getProcessId()));
        mapExpressions.putAll(this.getRealUsersName(sData, process.getProcessId()));
        mapExpressions.putAll(this.getLinks(sData, process.getProcessId()));
        if (sData.contains(START_ROWS_TAG) && sData.contains(END_ROWS_TAG)) {
            sData = this.insertTabularData(sData, mapExpressions);
        }
        for (String str : mapExpressions.keySet()) {
            if (sData.indexOf("@" + str + "@") < 0) continue;
            Object obj = mapExpressions.get(str);
            if (obj instanceof Variable) {
                Variable var = (Variable)obj;
                if (var.getValue() != null) {
                    if (var.isArray()) {
                        String strVar = this.convertVarArrayToString(var, this.processService.getProcessIndexes(process.getProcessDefinition().getProcessDefinitionId()));
                        sData = sData.replace("@" + str + "@", strVar);
                        continue;
                    }
                    Object value = var.getValue();
                    String valueToTemplate = value == null ? "" : (value instanceof Double ? Formatter.doubleToString((double)((Double)value)) : value.toString());
                    sData = sData.replace("@" + str + "@", valueToTemplate);
                    continue;
                }
                sData = sData.replace("@" + str + "@", "");
                continue;
            }
            sData = sData.replace("@" + str + "@", mapExpressions.get(str).toString());
        }
        return sData;
    }

    private String insertTabularData(String data, Map<String, Object> mapExpressions) {
        int endPosition;
        Object parsedData = data;
        int startPosition = ((String)parsedData).indexOf(START_ROWS_TAG);
        while (startPosition != -1 && (endPosition = ((String)parsedData).indexOf(END_ROWS_TAG, startPosition + START_ROWS_TAG.length())) != -1) {
            String templateBetweenTags = ((String)parsedData).substring(startPosition + START_ROWS_TAG.length(), endPosition);
            Matcher matcher = TAG_PATTERN.matcher(templateBetweenTags);
            ArrayList<String> variableTags = new ArrayList<String>();
            while (matcher.find()) {
                variableTags.add(matcher.group(1));
            }
            HashMap<String, Variable> templateVariablesMap = new HashMap<String, Variable>();
            for (String variableTag : variableTags) {
                Object value = mapExpressions.get(variableTag);
                if (!(value instanceof Variable)) continue;
                templateVariablesMap.put(variableTag, (Variable)value);
            }
            StringBuilder result = new StringBuilder();
            int templateRepeatCount = this.calculateTemplateRepeatCount(templateVariablesMap);
            for (int i = 0; i < templateRepeatCount; ++i) {
                String template = templateBetweenTags;
                for (Map.Entry variableEntry : templateVariablesMap.entrySet()) {
                    String replacement;
                    Variable variable = (Variable)variableEntry.getValue();
                    if (variable.isArray()) {
                        String value;
                        Object[] values = ArrayUtils.toArray((Object[])((Object[])variable.getValue()));
                        String string = value = i < values.length ? values[i] : "";
                        if (value == null) {
                            value = "";
                        }
                        replacement = String.valueOf(value);
                    } else {
                        replacement = Strings.nullToEmpty((String)((String)variable.getValue()));
                    }
                    template = template.replace(String.format("@%s@", variableEntry.getKey()), replacement);
                }
                result.append(template);
            }
            parsedData = ((String)parsedData).substring(0, startPosition) + result + ((String)parsedData).substring(endPosition + END_ROWS_TAG.length());
            startPosition = ((String)parsedData).indexOf(START_ROWS_TAG, startPosition + result.length());
        }
        return parsedData;
    }

    @Override
    public void setFeedbackVariable(Variable variable, List<String> emails) {
        if (variable.isArray()) {
            String result = String.join((CharSequence)";", emails);
            String[] arrayString = new String[]{result};
            variable.setValue((Object)arrayString);
        } else {
            String result = String.join((CharSequence)"\t \n", emails);
            variable.setValue((Object)result);
        }
    }

    private String convertVarArrayToString(Variable var, List<ProcessIndex> listProcessIndx) {
        StringBuilder builder = new StringBuilder();
        Boolean firstLoop = true;
        for (ProcessIndex processIndex : listProcessIndx) {
            if (!processIndex.getId().equals(var.getId())) continue;
            for (Object value : (Object[])var.getValue()) {
                if (!firstLoop.booleanValue()) {
                    builder.append(" , ");
                }
                if (value == null) {
                    builder.append(" ");
                } else if (value instanceof Double) {
                    builder.append(Formatter.doubleToString((double)((Double)value)));
                } else {
                    builder.append(value);
                }
                firstLoop = false;
            }
        }
        return builder.toString();
    }

    private Map<String, String> getRealUsersName(String sData, String sProcessId) {
        Map mapProcessContext = this.processService.getProcessContext(sProcessId);
        HashMap<String, String> mapRealUsersName = new HashMap<String, String>();
        int fromIndex = 0;
        while (sData.indexOf("@realusername#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@realusername#", fromIndex) + "@realusername#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sProcessVariable = sData.substring(beginIndex, endIndex);
            try {
                String sUserName = mapProcessContext.get(sProcessVariable).toString();
                if (sUserName.length() <= 0) continue;
                try {
                    String sUserFullName = this.userService.getUser(sUserName, new String[0]).getFullName();
                    mapRealUsersName.put("realusername#" + sProcessVariable, sUserFullName);
                }
                catch (NullPointerException e) {
                    mapRealUsersName.put("realusername#" + sProcessVariable, "@u\u017cytkownik nie istnieje!@");
                }
            }
            catch (NullPointerException e) {
                mapRealUsersName.put("realusername#" + sProcessVariable, "@realusername#" + sProcessVariable + ": (brak zmiennej w procesie)@");
            }
        }
        return mapRealUsersName;
    }

    private Map<String, String> getTaskUsers(String sData, String sProcessId) {
        ActivityService activityService = (ActivityService)SpringContext.getBean(ActivityService.class);
        List listActivity = this.activityFinder.findByProcessId(sProcessId, new String[0]);
        HashMap<String, String> mapTaskUsers = new HashMap<String, String>();
        int fromIndex = 0;
        while (sData.indexOf("@taskuser#", fromIndex) != -1) {
            User user;
            ActivityEntity activity;
            int endIndex;
            int beginIndex = sData.indexOf("@taskuser#", fromIndex) + "@taskuser#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sActivityDefId = sData.substring(beginIndex, endIndex);
            String sActivityId = null;
            for (Activity activity2 : listActivity) {
                if (!activity2.getActivityDefinitionId().equals(sActivityDefId)) continue;
                sActivityId = activity2.getActivityId();
                break;
            }
            if ((activity = (ActivityEntity)activityService.getActivity(sProcessId, sActivityId, new String[0])) == null || (user = this.userService.getUser(activity.getResourceId(), new String[0])) == null) continue;
            mapTaskUsers.put("taskuser#" + sActivityDefId, user.getFullName());
        }
        return mapTaskUsers;
    }

    private Map<String, String> getLinks(String sData, String sProcessId) {
        List listActivity = this.activityFinder.findByProcessId(sProcessId, new String[0]);
        HashMap<String, String> mapLinks = new HashMap<String, String>();
        String sHttpLink = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.HTTPLINK);
        int fromIndex = 0;
        while (sData.indexOf("@link#", fromIndex) != -1) {
            int endIndex;
            int beginIndex = sData.indexOf("@link#", fromIndex) + "@link#".length();
            fromIndex = endIndex = sData.indexOf("@", beginIndex);
            String sActivityDefId = sData.substring(beginIndex, endIndex);
            String sActivityId = null;
            for (Activity activity : listActivity) {
                if (!activity.getActivityDefinitionId().equals(sActivityDefId)) continue;
                sActivityId = activity.getActivityId();
                break;
            }
            mapLinks.put("link#" + sActivityDefId, sHttpLink + "/ShowDetailHistory.do?histActivityId=" + sActivityId + "&ProcessId=" + sProcessId);
        }
        String sHistoryLink = sHttpLink + "/ShowProcessHistory.do?ProcessId=" + sProcessId;
        mapLinks.put("historylink", sHistoryLink);
        return mapLinks;
    }

    @Override
    @Deprecated
    public File getContentHtml(MailConfiguration cfg, MailContent content, Addresses addresses, Boolean isHeader, String customHeaderTemplatePath) {
        Document doc = Jsoup.parse((String)"<html></html>");
        if (Boolean.TRUE.equals(isHeader)) {
            doc = this.loadTemplate(doc, customHeaderTemplatePath);
            this.fillTemplateValues(doc, cfg.getUser(), content, (List<String>)addresses.getDirectAddresses(), (List<String>)addresses.getCopyAddresses(), (List<String>)addresses.getHiddenCopyAddresses());
        } else {
            doc.body().append(content.getContent());
        }
        return this.createTempFile(doc);
    }

    @Override
    public File getContentHtml(EmailConfiguration cfg, MailContent content, Addresses addresses, Boolean isHeader, String customHeaderTemplatePath) {
        Document doc = Jsoup.parse((String)"<html></html>");
        if (Boolean.TRUE.equals(isHeader)) {
            doc = this.loadTemplate(doc, customHeaderTemplatePath);
            this.fillTemplateValues(doc, cfg.getMailUser(), content, (List<String>)addresses.getDirectAddresses(), (List<String>)addresses.getCopyAddresses(), (List<String>)addresses.getHiddenCopyAddresses());
        } else {
            doc.body().append(content.getContent());
        }
        return this.createTempFile(doc);
    }

    @Override
    public void logSendReport(SendReport sendReport) {
        this.logReport(sendReport.getFailedEmails(), sendReport.getSuccessfulEmails());
    }

    private String convert2HtmlSpans(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String string : list) {
            sb.append(this.buildHtmlSpan(string));
        }
        return sb.toString();
    }

    private String buildHtmlSpan(String string) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            sb.append("<span>").append(string).append("</span>");
        }
        return sb.toString();
    }

    @Override
    public void addDocumentFromProcessWithFileId(SimpleMailContent content, ActivityContextMap activityContextMap, List<String> fileIds) {
        List<DocumentAttachmentInfo> documentAttachmentInfos = this.builtAttachmentInfosSourceFromFileId(fileIds);
        ArrayList<List> allFilesVersionFromProcess = new ArrayList<List>();
        for (WfFile file : this.getAllFilesVersionFromProcess(activityContextMap.getProcessId())) {
            allFilesVersionFromProcess.add(this.fileFinder.getAllVersionsForFile(Long.valueOf(file.getId())));
        }
        for (List fileFromProcess : allFilesVersionFromProcess) {
            documentAttachmentInfos.forEach(documentAttachmentInfo -> fileFromProcess.stream().filter(wfFileVersion -> wfFileVersion.getFile().getId() == documentAttachmentInfo.getFileId().longValue()).forEach(wfFileVersion -> {
                String prefix = documentAttachmentInfo.getPrefix();
                Object attachmentName = wfFileVersion.getFile().getFileName();
                if (StringUtils.isNotBlank((CharSequence)prefix)) {
                    attachmentName = prefix + (String)attachmentName;
                }
                log.info("Attachment name=" + (String)attachmentName);
                content.getDocuments().put(wfFileVersion.getFile().getId(), attachmentName);
            }));
        }
    }

    public void addDocumentFromProcessWithDocumentClass(List<DocumentAttachmentInfo> documentAttachmentInfos, SimpleMailContent content, ActivityContextMap activityContextMap) {
        documentAttachmentInfos.forEach(documentAttachmentInfo -> this.documentFinder.getDocumentsFromProcessAndClass(activityContextMap.getProcessId(), documentAttachmentInfo.getDocumentClassName(), new String[]{"documentClass"}).stream().filter(wfDocument -> StringUtils.isBlank((CharSequence)documentAttachmentInfo.getFileNameRegexp()) || wfDocument.getFile().getFileName().matches(documentAttachmentInfo.getFileNameRegexp())).sorted(Comparator.comparing(o -> o.getFile().getFileName())).forEach(wfDocument -> {
            String prefix = documentAttachmentInfo.getPrefix();
            Object attachmentName = wfDocument.getFile().getFileName();
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                attachmentName = prefix + (String)attachmentName;
            }
            log.debug("Attachment name=" + (String)attachmentName);
            content.addWfDocument((String)attachmentName, wfDocument);
        }));
    }

    public List<DocumentAttachmentInfo> builtAttachmentInfosSourceFromDocumentClass(Map<String, String> docClassAndPrefix, Map<String, String> docClassAndFileNameRegexp) {
        return docClassAndPrefix.entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getKey()))).map(entry -> DocumentAttachmentInfo.builder().documentClassName((String)entry.getKey()).fileNameRegexp((String)docClassAndFileNameRegexp.get(entry.getKey())).prefix((String)entry.getValue()).build()).collect(Collectors.toList());
    }

    public List<DocumentAttachmentInfo> builtAttachmentInfosSourceFromFileId(List<String> fileId) {
        return fileId.stream().filter(StringUtils::isNotBlank).map(entry -> DocumentAttachmentInfo.builder().fileId(Long.valueOf(entry)).build()).collect(Collectors.toList());
    }

    List<WfFile> getAllFilesVersionFromProcess(String processId) {
        return this.fileFinder.getDocumentsFromProcess(processId, new String[0]).stream().sorted(Comparator.comparing(WfFile::getFileName)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadTemplate(Document doc, String customHeaderTemplatePath) {
        InputStream inputStream = null;
        try {
            if (StringUtils.isBlank((CharSequence)customHeaderTemplatePath)) {
                ClassLoader classLoader = EmailEngineImpl.class.getClassLoader();
                inputStream = classLoader.getResourceAsStream("templates/header-email-template.html");
            } else {
                inputStream = FileUtils.openInputStream((File)new File(customHeaderTemplatePath));
            }
            String contentFile = IOUtils.toString((InputStream)Objects.requireNonNull(inputStream), (String)StandardCharsets.UTF_8.name());
            doc = Jsoup.parse((String)contentFile);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return doc;
    }

    private void fillTemplateValues(Document doc, String user, MailContent content, List<String> directAddresses, List<String> copyAddresses, List<String> hiddenCopyAddresses) {
        List<String> attachedFiles = content.getAttachedFiles().stream().map(com.suncode.cuf.mail.FileAttachment::getName).collect(Collectors.toList());
        this.fillTemplateValues(doc, user, content.getContent(), content.getSubject(), attachedFiles, directAddresses, copyAddresses, hiddenCopyAddresses);
    }

    private File createTempFile(Document doc) {
        String workingDirectory = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
        String millis = Long.toString(DateTime.now().getMillis());
        String tempPath = workingDirectory + "/temp_email_" + millis + ".html";
        File file = new File(tempPath);
        try {
            FileUtils.writeStringToFile((File)file, (String)doc.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return file;
    }

    private void addComment(String message, ActivityContextMap activityContextMap) {
        Comment comment = new Comment();
        comment.setUserId(CreatorSettings.getAdminUserName());
        comment.setActivityId(activityContextMap.getActivityId());
        comment.setProcessId(activityContextMap.getProcessId());
        comment.setComment(StringUtils.left((String)message, (int)4000));
        comment.setTimestamp(Long.valueOf(new DateTime().getMillis()));
        this.commentService.createComment(comment);
    }

    @Override
    public void addHTMLDocumentToProcess(String saveDocClassName, String saveFileName, String saveDescription, Boolean saveAddHeader, Boolean saveAsNewVersion, String customHeaderTemplatePath, Map<String, String> saveNewIndexes, ActivityContextMap activityContextMap, UserInfo userInfo, EmailConfiguration emailConfiguration, AddressesDto addresses, EmailMessage emailMessage) {
        try {
            File file = this.getContentHtml(emailConfiguration, emailMessage, addresses, saveAddHeader, customHeaderTemplatePath);
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                this.docUtils.addNewWfDocument(saveDocClassName, FileTools.setFileName(saveFileName, "html"), saveDescription, activityContextMap.getProcessId(), userInfo == null ? null : userInfo.getUserName(), fileInputStream, saveNewIndexes, saveAsNewVersion);
                FileUtils.forceDelete((File)file);
                log.info("Deleted temp file");
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String parseErrorDescription(String errorDescription) {
        Object message = errorDescription.trim();
        int index = StringUtils.ordinalIndexOf((CharSequence)message, (CharSequence)";", (int)2);
        if (index > 0) {
            message = StringUtils.substring((String)message, (int)0, (int)index);
        }
        if (((String)message).length() > 250) {
            message = StringUtils.left((String)message, (int)250) + "...";
        }
        return message;
    }

    private String getExceptionMessage(Throwable throwable) {
        String message = throwable.getMessage();
        while (throwable.getCause() != null && StringUtils.isEmpty((CharSequence)message)) {
            throwable = throwable.getCause();
            message = throwable.getMessage();
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = throwable.getClass().getSimpleName();
        }
        return message;
    }

    private int calculateTemplateRepeatCount(Map<String, Variable> templateVariablesMap) {
        int repeats = 1;
        for (Map.Entry<String, Variable> variableEntry : templateVariablesMap.entrySet()) {
            Variable variable = variableEntry.getValue();
            if (!variable.isArray()) continue;
            repeats = Math.max(repeats, ArrayUtils.getLength((Object)variable.getValue()));
        }
        return repeats;
    }
}

