/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.dual;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.savefile.hook.DestinationFileHook;
import com.suncode.plugin.tools.savefile.service.SavingFileService;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.function.FunctionCall;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.component.ContextVariables;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.beans.ConstructorProperties;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/save-files-to-disk-dual-form.js")
public class SaveFilesToDiskDual {
    private static final Logger log = LoggerFactory.getLogger(SaveFilesToDiskDual.class);
    @Autowired
    private SavingFileService savingFileService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("tools.save-files-to-disk-dual")).name("tools.save-files-to-disk-dual.name")).description("tools.save-files-to-disk-dual.desc")).category(new Category[]{Categories.TOOLS})).icon((Icon)SilkIconPack.APPLICATION_GET)).contextVariable().id("fileNameWithExtension").name("tools.save-files-to-disk-dual.file-name-with-extension.name").description("tools.save-files-to-disk-dual.file-name-with-extension.desc").type((Type)Types.STRING).create().contextVariable().id("fileNameWithoutExtension").name("tools.save-files-to-disk-dual.file-name-without-extension.name").description("tools.save-files-to-disk-dual.file-name-without-extension.desc").type((Type)Types.STRING).create().contextVariable().id("fileExtension").name("tools.save-files-to-disk-dual.file-extension.name").description("tools.save-files-to-disk-dual.file-extension.desc").type((Type)Types.STRING).create().parameter().id("filesDownloadingSource").name("tools.save-files-to-disk-dual.files-downloading-source.name").description("tools.save-files-to-disk-dual.files-downloading-source.desc").type((Type)Types.STRING).create()).parameter().id("documentClassNamesProcess").name("tools.save-files-to-disk-dual.document-class-names-process.name").description("tools.save-files-to-disk-dual.document-class-names-process.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("documentClassNameArchive").name("tools.save-files-to-disk-dual.document-class-name-archive.name").description("tools.save-files-to-disk-dual.document-class-name-archive.desc").type((Type)Types.STRING).optional().create()).parameter().id("indexName").name("tools.save-files-to-disk-dual.index-name.name").description("tools.save-files-to-disk-dual.index-name.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("indexValue").name("tools.save-files-to-disk-dual.index-value.name").description("tools.save-files-to-disk-dual.index-value.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("fileIdList").name("tools.save-files-to-disk-dual.file-id-list.name").description("tools.save-files-to-disk-dual.file-id-list.desc").type((Type)Types.INTEGER_ARRAY).optional().create()).parameter().id("directory").name("tools.save-files-to-disk-dual.directory.name").description("tools.save-files-to-disk-dual.directory.desc").type((Type)Types.STRING).create()).parameter().id("fileName").name("tools.save-files-to-disk-dual.file-name.name").description("tools.save-files-to-disk-dual.file-name.desc").type((Type)Types.FUNCTION).optional().create()).parameter().id("filenameFilter").name("tools.save-files-to-disk-dual.filename-filter.name").description("tools.save-files-to-disk-dual.filename-filter.desc").type((Type)Types.STRING).optional().create();
    }

    public void execute(ApplicationContext context, ContextVariables contextVariables, @Param String filesDownloadingSource, @Param String[] documentClassNamesProcess, @Param String documentClassNameArchive, @PairedParam(key="indexName", value="indexValue") Map<String, String> indexesMapping, @Param Integer[] fileIdList, @Param String directory, @Param FunctionCall fileName, @Param String filenameFilter) {
        this.run((WorkflowContext)context, contextVariables, filesDownloadingSource, documentClassNamesProcess, documentClassNameArchive, indexesMapping, fileIdList, directory, fileName, filenameFilter);
    }

    public void set(AcceptanceContext context, ContextVariables contextVariables, @Param String filesDownloadingSource, @Param String[] documentClassNamesProcess, @Param String documentClassNameArchive, @PairedParam(key="indexName", value="indexValue") Map<String, String> indexesMapping, @Param Integer[] fileIdList, @Param String directory, @Param FunctionCall fileName, @Param String filenameFilter) {
        this.run((WorkflowContext)context, contextVariables, filesDownloadingSource, documentClassNamesProcess, documentClassNameArchive, indexesMapping, fileIdList, directory, fileName, filenameFilter);
    }

    private void run(WorkflowContext context, ContextVariables contextVariables, String filesDownloadingSource, String[] documentClassNamesProcess, String documentClassNameArchive, Map<String, String> indexesMapping, Integer[] fileIdList, String directory, FunctionCall fileName, String filenameFilter) {
        FileNameContextUpdater fileContext = new FileNameContextUpdater(contextVariables);
        String regexFilter = this.createFilenameFilter(filenameFilter);
        String resolvedDirectory = this.resolveDirectory(directory);
        log.debug("Resolved filter: " + regexFilter);
        log.debug("Resolved directory: " + resolvedDirectory);
        switch (filesDownloadingSource) {
            case "PROCESS": {
                this.savingFileService.saveFilesFromProcess(context.getProcessId(), fileContext, resolvedDirectory, fileName, documentClassNamesProcess, regexFilter);
                break;
            }
            case "ARCHIVE": {
                this.savingFileService.saveFilesFromArchive(fileContext, documentClassNameArchive, indexesMapping, resolvedDirectory, fileName, regexFilter);
                break;
            }
            case "FILEIDS": {
                this.savingFileService.saveSelectedFilesByIds(fileContext, fileIdList, resolvedDirectory, fileName);
            }
        }
    }

    private String createFilenameFilter(String userFilter) {
        String filter = ".*";
        if (userFilter != null && !userFilter.trim().isEmpty()) {
            return userFilter.trim();
        }
        return filter;
    }

    private String resolveDirectory(String userDirectory) {
        String homeDirTag = "{PWFL_HOME}";
        String workingDirTag = "{WORKING_DIRECTORY}";
        if (userDirectory.contains(homeDirTag) && userDirectory.contains(workingDirTag)) {
            throw new IllegalArgumentException("Filename filter accepts only one tag at a time");
        }
        return userDirectory.replace(homeDirTag, System.getProperty("plusworkflow.home")).replace(workingDirTag, SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY));
    }

    private class FileNameContextUpdater
    extends DestinationFileHook {
        private ContextVariables contextVariables;

        @Override
        public void update(String name) {
            this.contextVariables.set("fileNameWithExtension", (Object)name);
            this.contextVariables.set("fileNameWithoutExtension", (Object)this.getFileNameWithoutExtension(name));
            this.contextVariables.set("fileExtension", (Object)this.getFileExtension(name));
        }

        private String getFileExtension(String fileName) {
            return FilenameUtils.getExtension((String)fileName);
        }

        private String getFileNameWithoutExtension(String fileName) {
            return FilenameUtils.removeExtension((String)fileName);
        }

        @ConstructorProperties(value={"contextVariables"})
        public FileNameContextUpdater(ContextVariables contextVariables) {
            this.contextVariables = contextVariables;
        }
    }
}

