/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.autotask;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.support.hibernate.type.StandardBasicTypes;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.process.Process;
import com.suncode.pwfl.workflow.variable.Variable;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.Shark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Application
public class GetLastExecutorTask {
    private static final Logger log = LoggerFactory.getLogger(GetLastExecutorTask.class);
    private static final String ORACLE_DRIVER = "oracle.jdbc.driver.OracleDriver";
    private static final String POSTGRESQL_DRIVER = "org.postgresql.Driver";
    private static final String SQLSERVER_DRIVER = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("get-last-executor-task")).name("application.get-last-executor-task.name")).description("application.get-last-executor-task.desc")).category(new Category[]{Categories.TOOLS_FOR_PROCESS})).icon((Icon)SilkIconPack.USER_SUIT)).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}login-of-the-last-user")).parameter().id("task-id").name("application.get-last-executor-task.param.task-id.name").type((Type)Types.STRING).create()).parameter().id("var-to-save-login").name("application.get-last-executor-task.param.var-to-save-login.name").type((Type)Types.VARIABLE).create()).parameter().id("vars-param").name("application.get-last-executor-task.param.vars-param.name").type((Type)Types.VARIABLE_ARRAY).optional().create();
    }

    public void execute(@Param(value="task-id") String taskId, @Param(value="var-to-save-login") Variable toSaveLoginVar, @Param(value="vars-param") Variable[] varsParam, ApplicationContext appContext) {
        Process process = ServiceFactory.getProcessService().getProcess(appContext.getProcessId(), new String[]{"processDefinition"});
        String processDefId = process.getProcessDefinition().getProcessDefinitionId();
        HashMap<String, Object> hmSearchMap = new HashMap<String, Object>();
        for (Variable variable : varsParam) {
            hmSearchMap.put(variable.getId(), variable.getValue());
        }
        String login = this.getTaskExecutor(processDefId, taskId, hmSearchMap, "laststatetime");
        toSaveLoginVar.setValue((Object)login);
    }

    private String getTaskExecutor(String processDefId, String activityName, Map<String, Object> hmSearchMap, String orderBy) {
        log.debug(MessageFormat.format("getTaskExecutor processDefId:{0},activityName:{1},hmSearchMap:{2}", processDefId, activityName, hmSearchMap.toString()));
        String driver = Shark.getInstance().getProperties().getProperty("DatabaseManager.DB.sharkdb.JdbcDriver");
        String result = "";
        StringBuilder query = new StringBuilder();
        if (driver.equals(ORACLE_DRIVER)) {
            query.append("SELECT * FROM (");
        } else if (driver.equals(SQLSERVER_DRIVER)) {
            query.append("SELECT * FROM (");
        }
        query.append(MessageFormat.format("SELECT DISTINCT pmidx.processid, resourceId, laststatetime FROM pm_idx_{0} pmidx JOIN activities a ON a.processid = pmidx.processid WHERE a.activitydefinitionid = :activityDefId AND a.state=1000007 AND resourceId IS NOT NULL ", processDefId));
        for (String key : hmSearchMap.keySet()) {
            query.append(MessageFormat.format(" AND {0} =:{0}", key));
        }
        switch (driver) {
            case "org.postgresql.Driver": {
                query.append(MessageFormat.format(" ORDER BY {0} DESC LIMIT 10", orderBy));
                break;
            }
            case "oracle.jdbc.driver.OracleDriver": {
                query.append(MessageFormat.format(" ORDER BY {0} DESC) WHERE ROWNUM <= 10", orderBy));
                break;
            }
            case "com.microsoft.sqlserver.jdbc.SQLServerDriver": {
                query.append(MessageFormat.format(") AS alias ORDER BY {0} DESC OFFSET 0 ROWS FETCH NEXT 10 ROWS ONLY", orderBy));
                break;
            }
            default: {
                query.append(MessageFormat.format(" ORDER BY {0} DESC", orderBy));
            }
        }
        SQLBuilder sqlBuilder = new SQLBuilder(query.toString());
        sqlBuilder.addScalar("resourceId", StandardBasicTypes.STRING);
        sqlBuilder.setParameter("activityDefId", (Object)activityName);
        for (Map.Entry<String, Object> entry : hmSearchMap.entrySet()) {
            sqlBuilder.setParameter(entry.getKey(), entry.getValue());
        }
        SQLFinder finder = FinderFactory.getSQLFinder();
        log.debug(sqlBuilder.buildQuery());
        List data = finder.find(sqlBuilder);
        if (data != null && data.size() > 0) {
            for (Map map : data) {
                String resourceId = (String)map.get("resourceId");
                if (ServiceFactory.getUserService().getUser(resourceId, new String[0]) == null) continue;
                result = resourceId;
                break;
            }
        }
        log.debug(MessageFormat.format("getTaskExecutor resourceId:{0}", result));
        return result;
    }
}

