/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.autotask;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.pwfl.administration.structure.role.RoleFilter;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

@Application
public class EmailFromUserRole {
    public static Logger log = Logger.getLogger(EmailFromUserRole.class);

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("email-address-from-user-role")).name("application.email-address-from-user-role.name")).description("application.email-address-from-user-role.desc")).category(new Category[]{Categories.TOOLS_EMAIL})).icon((Icon)SilkIconPack.EMAIL)).parameter().id("role-name").name("application.email-address-from-user-role.param.role-name.name").description("application.email-address-from-user-role.param.role-namedesc").type((Type)Types.STRING_ARRAY).create()).parameter().id("result-email-address").name("application.email-address-from-user-role.param.result-email-address.name").description("application.email-address-from-user-role.param.result-email-address.desc").type((Type)Types.VARIABLE).create()).parameter().id("package-id").name("application.email-address-from-user-role.param.package-id.name").description("application.email-address-from-user-role.param.package-id.desc").type((Type)Types.STRING).optional().create()).parameter().id("process-def-id").name("application.email-address-from-user-role.param.process-def-id.name").description("application.email-address-from-user-role.param.process-def-id.desc").type((Type)Types.STRING).optional().create();
    }

    public void execute(@Param(value="package-id") String packageId, @Param(value="process-def-id") String processDefId, @Param(value="role-name") String[] roleIds, @Param(value="result-email-address") Variable result, ActivityContextMap activityContextMap, ApplicationContext appContextMap) {
        UserFinder userFinder = FinderFactory.getUserFinder();
        log.debug((Object)"Przygotowanie filtru wyszukiwania uzytkownikow");
        ArrayList<RoleFilter> filters = new ArrayList<RoleFilter>();
        RoleFilter tempRole = new RoleFilter();
        if (packageId != null) {
            tempRole.setPackageId(packageId);
        }
        if (processDefId != null) {
            tempRole.setProcessDefId(processDefId);
        }
        tempRole.setRoleIds(Arrays.asList(roleIds));
        filters.add(tempRole);
        HashSet<String> emailAddresses = new HashSet<String>();
        log.debug((Object)"Szukanie uzytkownikow z pasujacymi rolami");
        List users = new ArrayList();
        try {
            users = userFinder.findByRoles(filters);
        }
        catch (Exception e) {
            log.debug((Object)(e.getClass().getName() + " : " + e.getMessage()));
            System.out.println(e.getClass().getName() + " : " + e.getMessage());
            log.error((Object)e);
        }
        log.debug((Object)("znaleziono " + users.size()));
        for (User user : users) {
            if (!user.getEmail().isEmpty()) {
                emailAddresses.add(user.getEmail());
            }
            log.debug((Object)(user.getFullName() + " : " + user.getEmail()));
            System.out.println(user.getFullName() + " : " + user.getEmail());
        }
        log.debug((Object)"Prygotowanie danych wyjsciowych");
        StringBuilder sb = new StringBuilder();
        Boolean firstLoop = true;
        for (String emailAddress : emailAddresses) {
            if (!firstLoop.booleanValue()) {
                sb.append(";");
            }
            sb.append(emailAddress);
            firstLoop = false;
        }
        String[] arrayString = new String[]{sb.toString()};
        log.debug((Object)"Zapiswyanie danych do zmiennej wyjsciowej");
        if (result.isArray()) {
            result.setValue((Object)arrayString);
        } else {
            result.setValue((Object)sb.toString().replaceAll(";", " , "));
        }
        log.debug((Object)"END application");
    }
}

