/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.autotask;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.docutils.DocUtils;
import com.suncode.plugin.tools.until.CreatorSettings;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.pdf.PdfConverter;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.xwpf.usermodel.XWPFDefaultParagraphStyle;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.joda.time.DateTime;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrGeneral;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@ComponentsFormScript(value="scripts/dynamic-form-pwe/tools.converter-word-pdf.js")
public class ConvertWordToPDF {
    private static final Logger log = LoggerFactory.getLogger(ConvertWordToPDF.class);
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentClassService documetnClassService;
    @Autowired
    private FileService fileService;
    @Autowired
    private DocUtils docUtils;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("tools.converter-word-pdf")).name("application.tools.converter-word-pdf.name")).description("application.tools.converter-word-pdf.desc")).category(new Category[]{Categories.TOOLS})).icon((Icon)SilkIconPack.PAGE_WHITE_ACROBAT)).parameter().id("doc-class-name-src").name("application.tools.converter-word-pdf.param.doc-class-name-src.name").type((Type)Types.STRING).create()).parameter().id("doc-class-name-to").name("application.tools.converter-word-pdf.param.doc-class-name-to.name").type((Type)Types.STRING).optional().create()).parameter().id("new-version").name("application.tools.converter-word-pdf.param.new-version.name").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("use-alternative-renderer").name("application.tools.converter-word-pdf.param.use-alternative-renderer.name").description("application.tools.converter-word-pdf.param.use-alternative-renderer.desc").type((Type)Types.BOOLEAN).optional().defaultValue((Object)Boolean.FALSE).create();
    }

    public void execute(@Param(value="doc-class-name-src") String docClassNameSrc, @Param(value="new-version") Boolean newVersion, @Param(value="doc-class-name-to") String docClassNameTo, @Param(value="use-alternative-renderer") Boolean useAlternativeRenderer, ApplicationContext appContext, UserInfo userInfo) throws Exception {
        Long documentClassIdto = this.documetnClassService.getDocumentClass(newVersion != false ? docClassNameSrc : docClassNameTo, new String[0]).getId();
        List<WfDocument> docsFromProces = this.docUtils.getDocumentsFromProcessAndClass(docClassNameSrc, appContext);
        String userName = this.getUserName(userInfo);
        ZipSecureFile.setMinInflateRatio((double)9.0E-4);
        long errorFiles = 0L;
        for (WfDocument wfDocument : docsFromProces) {
            if (Boolean.TRUE.equals(useAlternativeRenderer)) {
                Path tempPdf = Paths.get(this.getPdfPath(), new String[0]);
                try (FileOutputStream fileOutputStream = new FileOutputStream(tempPdf.toFile());
                     InputStream inputStream = ServiceFactory.getFileService().getFileInputStream(Long.valueOf(wfDocument.getFile().getId()));){
                    XWPFDocument docxDocument = new XWPFDocument(inputStream);
                    XWPFDefaultParagraphStyle pStyle = docxDocument.getStyles().getDefaultParagraphStyle();
                    CTPPrGeneral defaults = this.getDefaultParagraphStylePr(pStyle);
                    ((Stream)docxDocument.getBodyElements().stream().parallel()).forEach(iBodyElement -> {
                        if (iBodyElement instanceof XWPFParagraph) {
                            this.fixParagraphSpacing((XWPFParagraph)iBodyElement, defaults);
                        } else if (iBodyElement instanceof XWPFTable) {
                            ((XWPFTable)iBodyElement).getRows().forEach(row -> row.getTableCells().forEach(cell -> cell.getParagraphs().forEach(paragraph -> this.fixParagraphSpacing((XWPFParagraph)paragraph, defaults))));
                        }
                    });
                    PdfOptions pdfOptions = PdfOptions.create();
                    PdfConverter.getInstance().convert(docxDocument, (OutputStream)fileOutputStream, (Options)pdfOptions);
                    this.addDocument(tempPdf.toFile(), wfDocument, userName, appContext.getProcessId(), documentClassIdto, newVersion);
                    Files.delete(tempPdf);
                }
                catch (Exception e) {
                    ++errorFiles;
                }
                continue;
            }
            String pdfPath = this.getPdfPath();
            File pdf = PrepeareDoc.doc2PdfWithoutOO((WfFile)wfDocument.getFile(), (String)pdfPath);
            if (pdf == null) {
                log.error("Cannot convert document: '" + wfDocument.getFile().getFileName() + "' to PDF file.");
                ++errorFiles;
                continue;
            }
            this.addDocument(pdf, wfDocument, userName, appContext.getProcessId(), documentClassIdto, newVersion);
            if (pdf.delete()) continue;
            log.error("Error delete temp file: " + pdf.getAbsolutePath());
        }
        if (!docsFromProces.isEmpty() && errorFiles == (long)docsFromProces.size()) {
            throw new Docx4JException("No document has been converted to pdf file");
        }
    }

    private String getUserName(UserInfo userInfo) {
        if (userInfo != null && StringUtils.isNotBlank((CharSequence)userInfo.getUserName())) {
            return userInfo.getUserName();
        }
        return CreatorSettings.getAdminUserName();
    }

    private void addDocument(File newFile, WfDocument sourceDoc, String userName, String processId, Long newClassId, Boolean newVersion) throws Exception {
        FileInputStream is = new FileInputStream(newFile);
        DocumentDefinition definition = new DocumentDefinition();
        definition.setDocumentClassId(newClassId);
        definition.setFileName(this.newFileName(sourceDoc.getFile().getFileName()));
        definition.setDescription(sourceDoc.getFile().getDescription());
        definition.setUserName(userName);
        definition.setInputStream((InputStream)is);
        definition.setProcessId(processId);
        if (newVersion.booleanValue()) {
            this.fileService.checkIn(definition, Long.valueOf(sourceDoc.getFile().getId()), "");
        } else {
            this.documentService.addDocument(definition);
        }
    }

    private String newFileName(String fileName) {
        CharSequence[] words = fileName.split("\\.");
        if (words.length > 1) {
            words[words.length - 1] = "pdf";
        }
        return String.join((CharSequence)".", words);
    }

    private String getPdfPath() {
        String workingDirectory = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
        String millis = Long.toString(DateTime.now().getMillis());
        return workingDirectory + "/temp_" + millis + ".pdf";
    }

    private void fixParagraphSpacing(XWPFParagraph paragraph, CTPPrGeneral defaults) {
        if (paragraph.getText().isEmpty()) {
            paragraph.getRuns().forEach(run -> run.setText(" "));
        }
        if (defaults.isSetSpacing() && paragraph.getCTP().isSetPPr() && paragraph.getCTP().getPPr().isSetSpacing()) {
            CTSpacing sSpacing = defaults.getSpacing();
            CTSpacing pSpacing = paragraph.getCTP().getPPr().getSpacing();
            this.setCorrectSpacing(sSpacing, pSpacing);
        }
        if (paragraph.getCTP().isSetPPr() && paragraph.getCTP().getPPr().isSetSpacing() && paragraph.getStyleID() != null) {
            XWPFStyle baseStyle;
            XWPFStyle pStyle = paragraph.getDocument().getStyles().getStyle(paragraph.getStyleID());
            if (pStyle.getCTStyle().isSetPPr() && pStyle.getCTStyle().getPPr().isSetSpacing()) {
                this.setCorrectSpacing(pStyle.getCTStyle().getPPr().getSpacing(), paragraph.getCTP().getPPr().getSpacing());
            }
            if (pStyle.getBasisStyleID() != null && (baseStyle = paragraph.getDocument().getStyles().getStyle(pStyle.getBasisStyleID())).getCTStyle().isSetPPr() && baseStyle.getCTStyle().getPPr().isSetSpacing()) {
                this.setCorrectSpacing(baseStyle.getCTStyle().getPPr().getSpacing(), paragraph.getCTP().getPPr().getSpacing());
            }
        }
    }

    private void setCorrectSpacing(CTSpacing sSpacing, CTSpacing pSpacing) {
        if (sSpacing.isSetAfter()) {
            pSpacing.setAfter(sSpacing.getAfter());
        }
        if (sSpacing.isSetBefore()) {
            pSpacing.setBefore(sSpacing.getBefore());
        }
        if (sSpacing.isSetLine()) {
            pSpacing.setLine(sSpacing.getLine());
        }
        if (sSpacing.isSetLineRule()) {
            pSpacing.setLineRule(sSpacing.getLineRule());
        }
    }

    private CTPPrGeneral getDefaultParagraphStylePr(XWPFDefaultParagraphStyle style) {
        CTPPrGeneral ctpPrGeneral = null;
        try {
            Field field = XWPFDefaultParagraphStyle.class.getDeclaredField("ppr");
            field.setAccessible(true);
            ctpPrGeneral = (CTPPrGeneral)field.get(style);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            log.error(e.getMessage());
        }
        return ctpPrGeneral;
    }
}

