/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.autotask;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.suncode.pdfutils.support.ElementAlignment;
import com.suncode.pdfutils.watermark.WatermarkImage;
import com.suncode.pdfutils.watermark.WatermarkText;
import com.suncode.plugin.tools.autotask.NewDocInfo;
import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.docutils.DocUtils;
import com.suncode.plugin.tools.pdfutils.PdfUtils;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.util.annotation.Deprecated;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Deprecated(replacement="watermark.add-watermark-to-document-app")
@Application
public class BarcodePDF {
    private static final Logger log = LoggerFactory.getLogger(BarcodePDF.class);
    @Autowired
    private PdfUtils pdfUtils;
    @Autowired
    private DocUtils docUtils;
    @Autowired
    private FileService fileService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("tools.barcode-pdf-app")).name("tools.barcode-pdf-app.name")).description("tools.barcode-pdf-app.desc")).category(new Category[]{Categories.TOOLS_FOR_PROCESS})).icon((Icon)SilkIconPack.IMAGE_ADD)).parameter().id("format").name("tools.barcode-pdf-app.param.format.name").type((Type)Types.STRING).create()).parameter().id("code").name("tools.barcode-pdf-app.param.code.name").type((Type)Types.STRING).create()).parameter().id("docClassName").name("tools.barcode-pdf-app.param.docClassName.name").type((Type)Types.STRING).create()).parameter().id("barSizeX").name("tools.barcode-pdf-app.param.barSizeX.name").type((Type)Types.INTEGER).defaultValue((Object)50).create()).parameter().id("barSizeY").name("tools.barcode-pdf-app.param.barSizeY.name").type((Type)Types.INTEGER).defaultValue((Object)50).create()).parameter().id("opacity").name("tools.barcode-pdf-app.param.opacity.name").description("tools.barcode-pdf-app.param.opacity.desc").type((Type)Types.FLOAT).defaultValue((Object)0.5).create()).parameter().id("barPozX").name("tools.barcode-pdf-app.param.barPozX.name").description("tools.barcode-pdf-app.param.barPozX.desc").type((Type)Types.FLOAT).defaultValue((Object)25.0).create()).parameter().id("barPozY").name("tools.barcode-pdf-app.param.barPozY.name").description("tools.barcode-pdf-app.param.barPozY.desc").type((Type)Types.FLOAT).defaultValue((Object)25.0).create()).parameter().id("isTextON").name("tools.barcode-pdf-app.param.isTextON.name").type((Type)Types.BOOLEAN).defaultValue((Object)true).create()).parameter().id("fontPozX").name("tools.barcode-pdf-app.param.fontPozX.name").description("tools.barcode-pdf-app.param.fontPozX.desc").type((Type)Types.FLOAT).optional().defaultValue((Object)25.0).create()).parameter().id("fontPozY").name("tools.barcode-pdf-app.param.fontPozY.name").description("tools.barcode-pdf-app.param.fontPozY.desc").type((Type)Types.FLOAT).optional().defaultValue((Object)50.0).create()).parameter().id("fontSize").name("tools.barcode-pdf-app.param.fontSize.name").type((Type)Types.FLOAT).optional().defaultValue((Object)12.0).create();
    }

    public void execute(@Param(value="format") String format, @Param(value="code") String code, @Param(value="docClassName") String docClassName, @Param(value="barSizeX") Integer barSizeX, @Param(value="barSizeY") Integer barSizeY, @Param(value="opacity") Float opacity, @Param(value="barPozX") Float barPozX, @Param(value="barPozY") Float barPozY, @Param(value="isTextON") Boolean isTextOn, @Param(value="fontPozX") Float fontPozX, @Param(value="fontPozY") Float fontPozY, @Param(value="fontSize") Float fontSize, ApplicationContext appContext) throws Exception {
        log.debug("******* START BARCODE PDF APP ********");
        String barcodeImagePath = this.createBarCodeImage(code, format, barSizeX, barSizeY);
        WatermarkImage watermarkBarcode = new WatermarkImage(barcodeImagePath);
        watermarkBarcode.setOpacity(opacity);
        watermarkBarcode.setPositionX(barPozX);
        watermarkBarcode.setPositionY(barPozY);
        WatermarkText watermarkText = null;
        if (isTextOn.booleanValue()) {
            watermarkText = new WatermarkText(code);
            watermarkText.setOpacity(opacity);
            watermarkText.setPositionX(fontPozX != null ? fontPozX : barPozX);
            watermarkText.setPositionY(Float.valueOf(fontPozY != null ? fontPozY.floatValue() : barPozY.floatValue() - (float)barSizeY.intValue() - 12.0f));
            watermarkText.setColor(Color.BLACK);
            watermarkText.setAlignment(ElementAlignment.TOP_LEFT);
            watermarkText.setSize(Float.valueOf(fontSize != null ? fontSize.floatValue() : 12.0f));
            watermarkText.setRotation(Float.valueOf(0.0f));
        }
        List<WfDocument> docsFromProces = this.docUtils.getDocumentsFromProcessAndClass(docClassName, appContext);
        log.debug("Finded " + docsFromProces.size() + " documents");
        ArrayList<NewDocInfo> newDocInfos = new ArrayList<NewDocInfo>();
        try {
            for (WfDocument wfDocument : docsFromProces) {
                WfFile docFile = wfDocument.getFile();
                String fileName = docFile.getFileName();
                log.debug("FileName:\t" + fileName);
                String fileType = fileName.substring(fileName.length() - 3);
                if (fileType == null || !fileType.equalsIgnoreCase("pdf")) {
                    log.debug("File is not PDF format:\t");
                    continue;
                }
                log.debug("Add Barcode");
                InputStream is = this.pdfUtils.addBarcode(fileName, this.fileService.getFileInputStream(Long.valueOf(docFile.getId())), watermarkBarcode);
                if (is != null) {
                    if (isTextOn.booleanValue()) {
                        is = this.pdfUtils.addText(is, watermarkText);
                    }
                    NewDocInfo newDocInfo = new NewDocInfo();
                    newDocInfo.setIs(is);
                    newDocInfo.setDocument(wfDocument);
                    newDocInfos.add(newDocInfo);
                    continue;
                }
                log.debug("No stream");
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            File imageFileBar = new File(barcodeImagePath);
            if (imageFileBar.exists()) {
                log.debug("Delete: " + barcodeImagePath);
                imageFileBar.delete();
            }
        }
        for (NewDocInfo newDocInfo : newDocInfos) {
            log.debug("Add document to process");
            this.docUtils.addDocumentAsNewVersion(newDocInfo.getDocument(), newDocInfo.getIs(), appContext);
        }
        log.debug("******* END BARCODE PDF APP ********");
    }

    private String createBarCodeImage(String code, String formatName, int sizeX, int sizeY) throws WriterException, IOException {
        MultiFormatWriter barcodeWriter = new MultiFormatWriter();
        BarcodeFormat barcodeFormat = BarcodeFormat.valueOf((String)formatName);
        BitMatrix barcodeBitMatrix = barcodeWriter.encode(code, barcodeFormat, sizeX, sizeY);
        File file = new File(SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY) + File.separatorChar + "Barcode_" + DateTime.now().getMillis() + ".png");
        MatrixToImageWriter.writeToFile((BitMatrix)barcodeBitMatrix, (String)"png", (File)file);
        String imagePath = file.getAbsolutePath();
        return imagePath;
    }
}

