PWE.integrationComponent.registerApplication("tools.decryption-of-attached-file.dual", {
    apiVersion: 2,
    buildForm: function (form) {
        form.addCombobox({
            id: "destinationDocClass",
            remote: {
                url: "plugin/com.suncode.plugin-tools/docs/docClassList",
                fields: [{
                    name: "docClassName",
                    type: "string"
                }, {
                    name: "docClassDesc",
                    type: "string"
                }

                ]
            },
            valueField: "docClassName",
            displayField: "docClassName",
            sort: [{
                property: "docClassName",
                direction: "ASC"
            }]
        });
        form.addCombobox({
            id: "cipherAlgorithm",
            values: [
    			{ id: "AES", display: "AES" },
    			{ id: "Blowfish", display: "Blowfish" },
    			{ id: "DES", display: "DES" },
    			{ id: "RC2", display: "RC2" }
    		],
        });
        
        form.addField("attachToProcess");
        var encryptedFileTable = form.addTable({
            id: "encryptedFileTable",
            name: TOOLS.t("tools.encryptedFileTable.name"),
            description: TOOLS.t("tools.encryptedFileTable.desc"),
            notEmpty: true,
            optional: false
        });
        encryptedFileTable.addField("idsEncryptedFiles");
        encryptedFileTable.addField("encryptionKeys");
    }
});