PWE.integrationComponent.registerApplication('tools.application.printDocument', {
    apiVersion: 2,
    buildForm: function (form) {
        form.addField("printerName");
        form.addCombobox({
            id: "fileSource",
            values: [
                {id: "FILEID", display: TOOLS.t("tools.application.printDocument.fileSource.fileId")},
                {id: "DOCUMENTID", display: TOOLS.t("tools.application.printDocument.fileSource.documentId")},
                {id: "DOCUMENTCLASS", display: TOOLS.t("tools.application.printDocument.fileSource.documentClass")}
            ],
            listeners: {
                change: function (value) {
                    if (value === "DOCUMENTCLASS") {
                        toggleFieldsWhenFileSourceIsDocumentClass(form);
                    } else if (value === "FILEID") {
                        toggleFieldsWhenFileSourceIsFileId(form);
                    } else if (value === "DOCUMENTID") {
                        toggleFieldsWhenFileSourceIsDocumentId(form);
                    } else if (form.hasVariableValue("fileSource") || form.hasFunctionValue("fileSource")) {
                        toggleFieldsWhenFileSourceIsVariableOrFunction(form);
                    } else {
                        toggleFieldsWhenFileSourceIsUndefined(form);
                    }
                }
            }
        });
        form.addField("fileId");
        TOOLS.addComboboxClassList("documentClassDocumentId", null, form, null);
        form.addField("documentId");
        TOOLS.addComboboxClassList("documentClass", null, form, null);
        afterFileSourceLoad(form);
    }
});

function toggleFieldsWhenFileSourceIsDocumentClass(form) {
    form.setNotEmpty("documentClass", true);
    form.show("documentClass");
    form.setNotEmpty("fileId", false);
    form.hide("fileId");
    form.setNotEmpty("documentClassDocumentId", false);
    form.hide("documentClassDocumentId");
    form.setNotEmpty("documentId", false);
    form.hide("documentId");
}

function toggleFieldsWhenFileSourceIsFileId(form) {
    form.setNotEmpty("fileId", true);
    form.show("fileId");
    form.setNotEmpty("documentClass", false);
    form.hide("documentClass");
    form.setNotEmpty("documentClassDocumentId", false);
    form.hide("documentClassDocumentId");
    form.setNotEmpty("documentId", false);
    form.hide("documentId");
}

function toggleFieldsWhenFileSourceIsDocumentId(form) {
    form.setNotEmpty("documentClassDocumentId", true);
    form.show("documentClassDocumentId");
    form.setNotEmpty("documentId", true);
    form.show("documentId");
    form.setNotEmpty("documentClass", false);
    form.hide("documentClass");
    form.setNotEmpty("fileId", false);
    form.hide("fileId");
}

function toggleFieldsWhenFileSourceIsVariableOrFunction(form) {
    form.setNotEmpty("documentClassDocumentId", false);
    form.show("documentClassDocumentId");
    form.setNotEmpty("documentId", false);
    form.show("documentId");
    form.setNotEmpty("documentClass", false);
    form.show("documentClass");
    form.setNotEmpty("fileId", false);
    form.show("fileId");
}

function toggleFieldsWhenFileSourceIsUndefined(form) {
    form.setNotEmpty("documentClassDocumentId", false);
    form.hide("documentClassDocumentId");
    form.setNotEmpty("documentId", false);
    form.hide("documentId");
    form.setNotEmpty("documentClass", false);
    form.hide("documentClass");
    form.setNotEmpty("fileId", false);
    form.hide("fileId");
}

function afterFileSourceLoad(form) {
    if (form.getValue("fileSource") === "DOCUMENTCLASS") {
        toggleFieldsWhenFileSourceIsDocumentClass(form);
    } else if (form.getValue("fileSource") === "FILEID") {
        toggleFieldsWhenFileSourceIsFileId(form);
    } else if (form.getValue("fileSource") === "DOCUMENTID") {
        toggleFieldsWhenFileSourceIsDocumentId(form);
    } else if (form.hasVariableValue("fileSource") || form.hasFunctionValue("fileSource")) {
        toggleFieldsWhenFileSourceIsVariableOrFunction(form);
    } else {
        toggleFieldsWhenFileSourceIsUndefined(form);
    }
}