PWE.integrationComponent.registerFormAction("tools.insert-html", {
	apiVersion: 2,
	buildForm: function (form) {

		this.KEYS = {
			BEGINNING_OF_THE_FORM: 'beginningOfTheForm',
			BEGINNING_OF_THE_FORM_T_KEY: 'tools.beginningOfTheForm.desc',
			END_OF_THE_FORM: 'endOfTheForm',
			END_OF_THE_FORM_T_KEY: 'tools.endOfTheForm.desc',
			BEFORE_VARIABLE: 'beforeVariable',
			BEFORE_VARIABLE_T_KEY: 'tools.beforeVariable.desc',
			AT_VARIABLE_HEIGHT: 'atVariableHeight',
			AT_VARIABLE_HEIGHT_T_KEY: 'tools.atVariableHeight.desc',
			AFTER_VARIABLE: 'afterVariable',
			AFTER_VARIABLE_T_KEY: 'tools.afterVariable.desc',
			BEFORE_TABLE: 'beforeTable',
			BEFORE_TABLE_T_KEY: 'tools.beforeTable.desc',
			AT_TABLE_HEIGHT: 'atTableHeight',
			AT_TABLE_HEIGHT_T_KEY: 'tools.atTableHeight.desc',
			AFTER_TABLE: 'afterTable',
			AFTER_TABLE_T_KEY: 'tools.afterTable.desc'
		}

		form.addField("html");

		form.addCombobox({
			id: "positionOnForm",
			values: [
				{ id: KEYS.BEGINNING_OF_THE_FORM, display: TOOLS.t(KEYS.BEGINNING_OF_THE_FORM_T_KEY) },
				{ id: KEYS.END_OF_THE_FORM, display: TOOLS.t(KEYS.END_OF_THE_FORM_T_KEY) },
				{ id: KEYS.BEFORE_VARIABLE, display: TOOLS.t(KEYS.BEFORE_VARIABLE_T_KEY) },
				{ id: KEYS.AT_VARIABLE_HEIGHT, display: TOOLS.t(KEYS.AT_VARIABLE_HEIGHT_T_KEY) },
				{ id: KEYS.AFTER_VARIABLE, display: TOOLS.t(KEYS.AFTER_VARIABLE_T_KEY) },
				{ id: KEYS.BEFORE_TABLE, display: TOOLS.t(KEYS.BEFORE_TABLE_T_KEY) },
				{ id: KEYS.AT_TABLE_HEIGHT, display: TOOLS.t(KEYS.AT_TABLE_HEIGHT_T_KEY) },
				{ id: KEYS.AFTER_TABLE, display: TOOLS.t(KEYS.AFTER_TABLE_T_KEY) }
			],
			listeners:{
				change: function(value){
					showHideVariables(value);
				}
			}
		});
		form.addField("variable");
		form.addField("tableId");

		this.showHideVariables = function(positionOnFormValue){

			switch(positionOnFormValue) {
				case KEYS.BEGINNING_OF_THE_FORM:
				case KEYS.END_OF_THE_FORM:
					form.hide("variable");
					form.hide("tableId");
					break;
				case KEYS.BEFORE_VARIABLE:
				case KEYS.AT_VARIABLE_HEIGHT:
				case KEYS.AFTER_VARIABLE:
					form.show("variable");
					form.hide("tableId");
					break;
				case KEYS.BEFORE_TABLE:
				case KEYS.AT_TABLE_HEIGHT:
				case KEYS.AFTER_TABLE:
					form.hide("variable");
					form.show("tableId");
					break;
				default:
					form.hide("variable");
					form.hide("tableId");
			}
		};

		this.showHideVariables(form.getValue("positionOnForm"));
	},

	validateForm : function(api) {

		switch( api.getValue("positionOnForm") ) {
			case KEYS.BEFORE_VARIABLE:
			case KEYS.AT_VARIABLE_HEIGHT:
			case KEYS.AFTER_VARIABLE:
				if(!api.hasVariableValue("variable")) {

					api.markError("variable");
					return false;
				}
				break;
			case KEYS.BEFORE_TABLE:
			case KEYS.AT_TABLE_HEIGHT:
			case KEYS.AFTER_TABLE:
				if(api.getValue("tableId") == '') {

					api.markError("tableId");
					return false;
				}
				break;
			default:
				break;

			return true;
		}
	}
});