PWE.integrationComponent.registerApplication("tools.barcode-pdf-app", {
	apiVersion : 2,
	buildForm : function(form) {
		form.addCombobox({
			id : "docClassName",
			remote : {
				url : "plugin/com.suncode.plugin-tools/docs/docClassList",
				fields : [ {
					name : "docClassName",
					type : "string"
				}, {
					name : "docClassDesc",
					type : "string"
				}

				]
			},
			valueField : "docClassName",
			displayField : "docClassName",
			sort : [ {
				property : "docClassName",
				direction : "ASC"
			} ]
		});
		form.addField( "code");
		form.addCombobox({
			id : "format",
			remote : {
				url : "plugin/com.suncode.plugin-tools/pdf/barcodeFormats",
				fields : [ {
					name : "name",
					type : "string"
				} ],
				remoteSort : true
			},
			valueField : "name",
			displayField : "name"

		});
		form.addField( "opacity");
		form.addLabel(TOOLS.t("barcode.label"))
		form.addField( "barPozX");
		form.addField( "barPozY");
		form.addField( "barSizeX");
		form.addField( "barSizeY");
		form.addLabel(TOOLS.t("text.label"))
		form.addField( { 
			id: "isTextON",
			listeners:{
				change: function(value){
					if(value){
						form.show("fontPozX");
						form.show("fontPozY");
						form.show("fontSize");
					}else{
						form.hide("fontPozX");
						form.hide("fontPozY");
						form.hide("fontSize");
					}
				}
			}
		} );
		form.addField( "fontPozX");
		form.addField( "fontPozY");
		form.addField( "fontSize");
		if(form.getValue("isTextON"))
		{
			form.show("fontPozX");
			form.show("fontPozY");
			form.show("fontSize");
		}else{
			form.hide("fontPozX");
			form.hide("fontPozY");
			form.hide("fontSize");
		}
	}
});
