var messageService = ServiceFactory.getMessageService();
/**
 * Return exchange rate action implementation.
 */
PW.FormActions.create('tools-exchange-rate-table-action', {

	defaultActions: {
		variableSet: function (variableSet, added, updated, removed) {
			this.setRowValues(added);
			this.updateFn(updated, this.get("currency"));
			this.updateFn(updated, this.get("date"));
		}
	},
	setExchangeRate: function (index, me) {
		var params = me.getParams(index, me);
		var resultColumn = me.get("result");
		var tableNoVar= me.get('tableNo');
    	var tableNameVar= me.get('tableName');
		if (params) {
			jQuery.ajax({
				url: 'plugin/com.suncode.plugin-tools/exchangerate/pln',
				type: "GET",
				data: params,
				success: function (data, textStatus, jqXHR) {
					resultColumn.setItemValue(data.mid, index);
					
					if(tableNoVar){
        		    	tableNoVar.setItemValue(data.no,index)
        		    }
        		   
        		    if(tableNameVar){
        		    	tableNameVar.setItemValue(data.table,index)
        		    }
				},
			});
		}
	},
	getParams: function (index, me) {
		var currency = me.get("currency").getValue();
		var date = me.get("date").getValue();
		if (currency === null || date === null) {
			return;
		}
		return {
			currency: currency[index],
			date: date[index]
		};
	},
	checkUpdate: function (updated, changeCol) {
		if (this.inArray(updated.changes, changeCol.getId())) {
			return true;
		}
		return false;
	},
	inArray: function (someArray, someItem) {
		for (var i = 0; i < someArray.length; i++) {
			if (someArray[i] == someItem)
				return true;
		}
		return false;
	},
	setRowValues: function (rows) {
		var fn = this.setExchangeRate
		var me = this;
		PW.each(rows, function (row) {
			this.setContextVariable("currentRow", row.index);
			if (this.get("condition") != null && this.get("condition") != undefined) {
				if (this.get("condition").call()) {
					fn(row.index, me)
				}
			} else {
				fn(row.index, me)
			}
		}, this);
	},
	updateFn: function (updated, updateCol) {
		if (updateCol == null || updateCol == undefined
			|| updateCol.length == 0) {
			this.setRowValues(updated);
		} else {
			var result = [];
			for (var j = 0; j < updated.length; j++) {
				if (this.checkUpdate(updated[j], updateCol)) {
					result.push(updated[j]);
				}
			}
			this.setRowValues(result);
		}
	},
});
