PW.FormActions.create('tools.document-info-versions', {
    init: function () {
        this.table = VariableSetService.get(this.get("table-id"));
    },
    formInit: function () {
        this.documentClassName = this.get("document-class-name");
        this.documentClassNames = this.get("document-class-names");

        const me = this;
        this.documentHookId = DocumentService.registerHook({
            refresh: function () {
                me.loadInfo();
            }
        });
    },
    variableSetInit: function (variableSet) {
        this.tableDestination = VariableSetService.get(variableSet.getId());
        variableSet.on('select', this.fnSelectedInfo, this);
    },
    enable: function () {
        this.enabled = true;

        if (this.target.type === "FORM") {
            this.loadInfo();
        }
    },
    disable: function () {
        this.enabled = false;
    },
    fnSelectedInfo: function () {
        const className = VariableSetService.getSelected(this.tableDestination).data[this.get("document-class-name-array").getId()];
        if (className) {
            this.documentClassName = className;
            this.loadInfo()
        }
    },
    defaultActions: {
        button: function () {
            this.documentClassName = this.get("document-class-name");
            this.documentClassNames = this.get("document-class-names");
            this.loadInfo();
        },
        variable: function (variable, newValue) {
            this.documentClassName = newValue;
            this.loadInfo();
        }
    },
    loadInfo: function () {
        if (this.enabled) {
            let docClassNames = [];
            const documentClassName = this.documentClassName || this.get("document-class-name");

            if (this.target.type === "BUTTON" || this.target.type === "FORM") {
                let documentClassNames = this.documentClassNames || this.get("document-class-names");
                let filteredDocClassNames = documentClassNames.filter(n => n != null);
                if (filteredDocClassNames.length === 0) {
                    if (documentClassName) {
                        docClassNames.push(documentClassName);
                    } else {
                        return false;
                    }
                } else {
                    docClassNames = filteredDocClassNames;
                }
            } else {
                if (!documentClassName) {
                    return false;
                }
                docClassNames.push(documentClassName);
            }

            const me = this;
            FormService.mask();
            jQuery.ajax({
                url: 'plugin/com.suncode.plugin-tools/docs/version/info',
                type: "POST",
                data: {
                    documentclassnames: docClassNames.join(","),
                    processid: processId,
                    activityid: activityId
                },
                success: function (result) {
                    me.setData(result.data);
                },
                error: function (result) {
                    MessageService.showFailure(TOOLS.t("tools.error.process.document.label"));
                    Logger.error(result);
                    return false;
                },
                complete: function () {
                    FormService.unmask();
                }
            });
        }
    },
    setData: function (data) {
        const wayOfAdding = this.get("wayOfAdding");
        if (wayOfAdding.indexOf('OVERWRITE_ALL_COLUMNS') > -1 || wayOfAdding.indexOf('UNSET') > -1) {
            VariableSetService.clear(this.table);
        }
        if(data.total==0) {
            return;
        }
        const add = wayOfAdding.indexOf('ADD') > -1;
        const oldValues = this.getOldValues();
        if (wayOfAdding.indexOf('OVERWRITE_UPDATED_COLUMNS') > -1 && this.get("rowSynch")) {
            //suspend events
            this.rowSync(data, oldValues)
        }
        this.setTargetVariable(this.get("docId"), "docId", data, add, oldValues);
        this.setTargetVariable(this.get("fileId"), "fileId", data, add, oldValues);
        this.setTargetVariable(this.get("fileName"), "fileName", data, add, oldValues);
        this.setTargetVariable(this.get("uploader"), "uploader", data, add, oldValues);
        this.setTargetVariable(this.get("fileDate"), "fileDate", data, add, oldValues);
        this.setTargetVariable(this.get("fileDateTime"), "fileDateTime", data, add, oldValues);
        this.setTargetVariable(this.get("version"), "version", data, add, oldValues);
        this.setTargetVariable(this.get("comment"), "comment", data, add, oldValues);
        this.setTargetVariable(this.get("documentClassName"), "documentClassName", data, add, oldValues);
    },
    checkProp: function () {
        if (this.get("fileId")) {
            return "fileId";
        }
    },
    rowSync: function (data, oldValues) {
        const varFileId = this.get("fileId");
        const propFileId = "fileId";
        if (varFileId) {
            let indexNew = (data.length - 1);
            const newValues = this.getArrayValues(data, propFileId, varFileId.getType());
            //skasuj wiersze niezawierające nowe fileID
            for (let index = (oldValues[propFileId].length - 1); index >= 0; index--) {
                if (newValues.indexOf(oldValues[propFileId][index]) < 0) {
                    this.table.getStore().removeAt(index);
                    oldValues.remove(index);
                }
            }
            //przestaw wiersza ze starym fileID tak by pasowało no nowych
            for (let index = (oldValues[propFileId].length - 1); index >= 0; index--) {
                while ((indexNew >= index) && (oldValues[propFileId][index] !== newValues[indexNew])) {
                    VariableSetService.insertRow(this.table, index + 1);
                    indexNew--;
                }
                indexNew--;
            }
            //dopisz brakujące wiersze na początku tabeli
            for (let index = indexNew; index >= 0; index--) {
                VariableSetService.insertRow(this.table, 0);
            }
        } else {
            Logger.error("No fileId column set. Skip row synchronization")
        }
    },
    setTargetVariable: function (target, prop, data, add, oldValues) {
        if (target) {
            const value = this.getArrayValues(data, prop, target.getType());
            if (add) {
                target.setValue(oldValues[prop].concat(value));
            } else {
                target.setValue(value);
            }
        }
    },
    getArrayValues: function (data, id, type) {
        const result = [];
        for (let i = 0; i < data.length; i++) {
            result.push(this.convertObject(data[i][id], type));
        }
        return result;
    },
    getOldValues: function () {
        const oldValues = [];
        oldValues["docId"] = (this.get("docId")) ? this.get("docId").getValue() : "";
        oldValues["fileId"] = (this.get("fileId")) ? this.get("fileId").getValue() : "";
        oldValues["fileName"] = (this.get("fileName")) ? this.get("fileName").getValue() : "";
        oldValues["uploader"] = (this.get("uploader")) ? this.get("uploader").getValue() : "";
        oldValues["fileDate"] = (this.get("fileDate")) ? this.get("fileDate").getValue() : "";
        oldValues["fileDateTime"] = (this.get("fileDateTime")) ? this.get("fileDateTime").getValue() : "";
        oldValues["version"] = (this.get("version")) ? this.get("version").getValue() : "";
        oldValues["comment"] = (this.get("comment")) ? this.get("comment").getValue() : "";
        oldValues["documentClassName"] = (this.get("documentClassName")) ? this.get("documentClassName").getValue() : "";
        return oldValues;
    },
    convertObject: function (value, type) {
        if (!value) {
            return null;
        }
        if (type.is("integer") || type.is("float") || type.is("integer[]") || type.is("float[]")) {
            return Number(value);
        } else if (type.is("datetime") || type.is("date") || type.is("date[]")) {
            return new Date(value);
        } else if (type.is("boolean")) {
            return (value === 'true');
        }
        return value;
    }
});