PW.FormActions.create('selected-row', {
    variableSetInit: function (table) {
        this.table = table;
        this.columnCondVariable = this.get("column-conditional-var");
        this.columRawDataVar = this.get("column-raw-data");
        this.variableToSave = this.get("variable-to-save");
    },

    enable: function () {
        this.rewrite();
    },

    defaultActions: {
        button: function (button) {
        },

        variableSet: function (variableSet, added, updated, removed) {
            if (updated.length > 0
                && updated[0].changes[0] != this.columRawDataVar.getId()
                && updated[0].changes[0] != this.columnCondVariable.getId()) {
                return;
            }
            this.rewrite();
        }
    },

    setResult: function (tableResult) {
        let variableSet = VariableSetService.get(this.table.getId());
        variableSet.getStore().suspendEvents(false);
        if (this.variableToSave.type.isArray) {
            if (this.get("table-id")) {
                VariableSetService.clear(VariableSetService.get(this.get("table-id")));
            }
            this.variableToSave.setValue(tableResult);
        } else {
            this.variableToSave.setValue(tableResult.join(','));
        }
        variableSet.getStore().resumeEvents();
        variableSet.getView().refresh();
    },

    rewrite: function () {
        let columnCondString = this.get("column-conditional-string");
        let rawArray = this.columRawDataVar.getValue();
        let cndArray = this.columnCondVariable.getValue();
        let tableResult = [];
        for (let int = 0; int < cndArray.length; int++) {
            let rewritten = false;
            for (let index = 0; index < columnCondString.length; index++) {
                if (cndArray[int] != null && cndArray[int].toString().match(columnCondString[index])) {
                    tableResult.push(rawArray[int])
                    rewritten = true;
                    break;
                }
            }

            if (this.get("orignal-length") && !rewritten) {
                tableResult.push(null);
            }
        }
        this.setResult(tableResult);
    }
});
