PW.FormActions.create('painting-table', {
    variableSetInit: function (variableSet) {
        this.bgColor = this.get("background-color");
        this.txtColor = this.get("color");
        this.table = variableSet;
        this.columnsIds = [];
        this.style = "";

        if (this.bgColor != null) {
            this.bgColor = this.bgColor.replace("hash", "#");
            this.style += " background-color: " + this.bgColor + "; ";
        }
        if (this.txtColor != null) {
            this.txtColor = this.txtColor.replace("hash", "#");
            this.style += " color: " + this.txtColor + "; ";
        }

        let columns = this.get("columns-id");
        for (let index = 0; index < columns.length; index++) {
            this.columnsIds.push(columns[index].getId());
        }

        this.customRender();
    },
    enable: function () {
        this.isEnable = true;
        this.table.refresh();
    },
    disable: function () {
        this.isEnable = false;
        this.table.refresh();
    },
    paint: function (me, metaData, column) {
        if (metaData.row < me.columnLength(column)) {
            metaData.style = me.style;
        }
    },
    customRender: function () {
        VariableSetService.addRenderer(this.table.grid, (value, data, column, metaData) => {
            if (this.isEnable) {
                this.paint(this, metaData, column);
            }
        }, this.columnsIds);
    },
    columnLength: function (column) {
        let tableVariables = this.table.getVariables();
        for (let i = 0; i < tableVariables.length; i++) {
            if (tableVariables[i].id === column) {
                return tableVariables[i].getValue().length;
            }
        }
        return -1;
    }
});