/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.until;

import java.util.HashMap;
import java.util.Map;
import pl.allegro.finance.tradukisto.MoneyConverters;

public class MoneyConverterUtils {
    private static final Map<String, String> TRANSLATIONS = new HashMap<String, String>();

    private MoneyConverterUtils() {
    }

    public static String getNegativeTranslation(String language) {
        return TRANSLATIONS.getOrDefault(language, "minus");
    }

    public static MoneyConverters getConverterLanguage(String language) {
        switch (language.toLowerCase()) {
            case "german": 
            case "de": {
                return MoneyConverters.GERMAN_BANKING_MONEY_VALUE;
            }
            case "russian": 
            case "ru": {
                return MoneyConverters.RUSSIAN_BANKING_MONEY_VALUE;
            }
            case "italian": 
            case "it": {
                return MoneyConverters.ITALIAN_BANKING_MONEY_VALUE;
            }
            case "polish": 
            case "pl": {
                return MoneyConverters.POLISH_BANKING_MONEY_VALUE;
            }
            case "czech": 
            case "cs": {
                return MoneyConverters.CZECH_BANKING_MONEY_VALUE;
            }
            case "slovak": 
            case "sk": {
                return MoneyConverters.SLOVAK_BANKING_MONEY_VALUE;
            }
            case "latvian": 
            case "lv": {
                return MoneyConverters.LATVIAN_BANKING_MONEY_VALUE;
            }
            case "kazakh": 
            case "kk": {
                return MoneyConverters.KAZAKH_BANKING_MONEY_VALUE;
            }
            case "ukrainian": 
            case "uk": {
                return MoneyConverters.UKRAINIAN_BANKING_MONEY_VALUE;
            }
            case "serbian": 
            case "sr": {
                return MoneyConverters.SERBIAN_BANKING_MONEY_VALUE;
            }
            case "serbian cyrillic": 
            case "sr-cyrl": {
                return MoneyConverters.SERBIAN_CYRILLIC_BANKING_MONEY_VALUE;
            }
            case "french": 
            case "fr": {
                return MoneyConverters.FRENCH_BANKING_MONEY_VALUE;
            }
            case "turkish": 
            case "tr": {
                return MoneyConverters.TURKISH_BANKING_MONEY_VALUE;
            }
            case "brazilian": 
            case "portuguese": 
            case "pt-br": {
                return MoneyConverters.BRAZILIAN_PORTUGUESE_BANKING_MONEY_VALUE;
            }
        }
        return MoneyConverters.ENGLISH_BANKING_MONEY_VALUE;
    }

    static {
        TRANSLATIONS.put("english", "minus");
        TRANSLATIONS.put("german", "Minus");
        TRANSLATIONS.put("russian", "\u043c\u0438\u043d\u0443\u0441");
        TRANSLATIONS.put("italian", "meno");
        TRANSLATIONS.put("polish", "minus");
        TRANSLATIONS.put("czech", "minus");
        TRANSLATIONS.put("slovak", "minus");
        TRANSLATIONS.put("latvian", "minus");
        TRANSLATIONS.put("kazakh", "\u043c\u0438\u043d\u0443\u0441");
        TRANSLATIONS.put("ukrainian", "\u043c\u0456\u043d\u0443\u0441");
        TRANSLATIONS.put("serbian", "minus");
        TRANSLATIONS.put("serbian cyrillic", "\u043c\u0438\u043d\u0443\u0441");
        TRANSLATIONS.put("french", "moins");
        TRANSLATIONS.put("turkish", "eksi");
        TRANSLATIONS.put("brazilian", "menos");
        TRANSLATIONS.put("portuguese", "menos");
    }
}

