/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.service;

import com.suncode.plugin.tools.service.DocumentArchiveService;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.search.CountedResult;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DocumentArchiveServiceImpl
implements DocumentArchiveService {
    private static final Logger log = LoggerFactory.getLogger(DocumentArchiveServiceImpl.class);
    @Autowired
    private FileFinder fileFinder;
    @Autowired
    DocumentClassService documentClassService;

    @Override
    public List<WfFile> findUnencryptedFiles(long docClassId, Date startDate, Date endDate, long greaterThanId, int limit) {
        return this.findFiles(docClassId, startDate, endDate, false, 0, limit, greaterThanId);
    }

    @Override
    public List<WfFile> findEncryptedFiles(long docClassId, Date startDate, Date endDate, long greaterThanId, int limit) {
        return this.findFiles(docClassId, startDate, endDate, true, 0, limit, greaterThanId);
    }

    private List<WfFile> findFiles(Long documentClassId, Date startDate, Date endDate, boolean findEncryptedFile, int start, int limit, long greaterThanId) {
        CountedResult byDocumentClassName;
        LinkedList<WfFile> result = new LinkedList<WfFile>();
        String documentClassName = ((DocumentClass)this.documentClassService.get((Serializable)documentClassId)).getName();
        int shift = 0;
        while (result.size() < limit && !(byDocumentClassName = this.fileFinder.findByDocumentClassName(documentClassName, Integer.valueOf(start + shift), Integer.valueOf(start + shift + limit))).getData().isEmpty()) {
            result.addAll(this.filterDocuments(startDate, endDate, findEncryptedFile, greaterThanId, (CountedResult<WfFile>)byDocumentClassName));
            shift += limit;
        }
        return result.subList(start, Integer.min(limit, result.size()));
    }

    private List<WfFile> filterDocuments(Date startDate, Date endDate, boolean findEncryptedFile, long greaterThanId, CountedResult<WfFile> byDocumentClassName) {
        return byDocumentClassName.getData().stream().filter(file -> file.getId() > greaterThanId && file.getFileDate().after(startDate) && file.getFileDate().before(endDate) && file.isEncrypted() == findEncryptedFile).sorted(Comparator.comparingLong(WfFile::getId)).collect(Collectors.toList());
    }

    @Override
    public List<WfFile> findUncompressedFiles(long docClassId, Date startDate, Date endDate) {
        return this.fileFinder.getAllDocumentsFromDocumentClass(String.valueOf(docClassId)).stream().filter(wfFile -> !wfFile.isCompressed()).filter(wfFile -> wfFile.getFileDate().after(startDate) && wfFile.getFileDate().before(endDate)).collect(Collectors.toList());
    }

    @Override
    public List<WfFile> findCompressedFiles(long docClassId, Date startDate, Date endDate) {
        return this.fileFinder.getAllDocumentsFromDocumentClass(String.valueOf(docClassId)).stream().filter(WfFile::isCompressed).filter(wfFile -> wfFile.getFileDate().after(startDate) && wfFile.getFileDate().before(endDate)).collect(Collectors.toList());
    }
}

