/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.scheduledtask.util;

import com.suncode.plugin.tools.json.util.JsonConverter;
import com.suncode.plugin.tools.scheduledtask.dto.WfFileDto;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.search.Sorter;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.search.sql.SQLFilter;
import com.suncode.pwfl.search.sql.SQLFinder;
import com.suncode.pwfl.search.sql.SimpleSQLFilter;
import com.suncode.pwfl.support.hibernate.type.StandardBasicTypes;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.SpringContext;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PropertyInjector {
    public static String injectProperties(String json, WfFileDto wfFileDto, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        Map<String, String> updatedMap = JsonConverter.convertJsonToMap(json).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> PropertyInjector.injectProperty((String)e.getValue(), wfFileDto, scheduledTaskInstanceInfo)));
        return JsonConverter.convertMapToJson(updatedMap);
    }

    private static String injectProperty(String property, WfFileDto wfFileDto, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        String replacedString = PropertyInjector.injectFilesProperty(property, wfFileDto);
        replacedString = PropertyInjector.injectLastSuccessfulExecutionTime(replacedString, scheduledTaskInstanceInfo);
        return PropertyInjector.injectCurrentTime(replacedString);
    }

    public static String injectFilesProperty(String parameters, WfFileDto wfFileDto) {
        String[] markers;
        WfFile doc;
        block3: {
            block2: {
                FileService fileService = (FileService)SpringContext.getBean(FileService.class);
                doc = fileService.getFile(Long.valueOf(wfFileDto.getId()), new String[]{"documentClass"});
                markers = new String[]{"{id}", "{name}", "{org_name}", "{path}", "{cipher_algorithm}", "{cipher_key}", "{file_date}", "{uploader}", "{description}", "{file_size}", "{compressed}", "{encrypted}", "{doc_class_id}", "{doc_class_name}"};
                if (StringUtils.isBlank((CharSequence)parameters)) break block2;
                if (!Arrays.stream(markers).noneMatch(parameters::contains)) break block3;
            }
            return parameters;
        }
        return parameters.replace(markers[0], StringUtils.isNotBlank((CharSequence)String.valueOf(doc.getId())) ? String.valueOf(doc.getId()) : "").replace(markers[1], StringUtils.isNotBlank((CharSequence)doc.getFileName()) ? doc.getFileName() : "").replace(markers[2], StringUtils.isNotBlank((CharSequence)wfFileDto.getSystemFileName()) ? wfFileDto.getSystemFileName() : "").replace(markers[3], StringUtils.isNotBlank((CharSequence)doc.getFullPath()) ? doc.getFullPath() : "").replace(markers[4], StringUtils.isNotBlank((CharSequence)doc.getCipherAlgorithm()) ? doc.getCipherAlgorithm() : "").replace(markers[5], StringUtils.isNotBlank((CharSequence)doc.getCipherKey()) ? doc.getCipherKey() : "").replace(markers[6], StringUtils.isNotBlank((CharSequence)String.valueOf(doc.getFileDate())) ? String.valueOf(doc.getFileDate()) : "").replace(markers[7], StringUtils.isNotBlank((CharSequence)doc.getUploader()) ? doc.getUploader() : "").replace(markers[8], StringUtils.isNotBlank((CharSequence)doc.getDescription()) ? doc.getDescription() : "").replace(markers[9], StringUtils.isNotBlank((CharSequence)String.valueOf(doc.getSize())) ? String.valueOf(doc.getSize()) : "").replace(markers[10], StringUtils.isNotBlank((CharSequence)String.valueOf(doc.isCompressed())) ? String.valueOf(doc.isCompressed()) : "").replace(markers[11], StringUtils.isNotBlank((CharSequence)String.valueOf(doc.isEncrypted())) ? String.valueOf(doc.isEncrypted()) : "").replace(markers[12], StringUtils.isNotBlank((CharSequence)String.valueOf(doc.getDocumentClass().getId())) ? String.valueOf(doc.getDocumentClass().getId()) : "").replace(markers[13], StringUtils.isNotBlank((CharSequence)doc.getDocumentClass().getName()) ? doc.getDocumentClass().getName() : "");
    }

    public static String injectCurrentTime(String replacedString) {
        String[] markers;
        block3: {
            block2: {
                markers = new String[]{"{current_timestamp}", "{current_DD}", "{current_MM}", "{current_YY}", "{current_YYYY}", "{current_hh}", "{current_mm}", "{current_ss}", "{current_nnn}"};
                if (StringUtils.isBlank((CharSequence)replacedString)) break block2;
                if (!Arrays.stream(markers).noneMatch(replacedString::contains)) break block3;
            }
            return replacedString;
        }
        Timestamp timestamp = Timestamp.from(Instant.now());
        return PropertyInjector.replaceTime(replacedString, markers, timestamp);
    }

    private static String replaceTime(String replacedString, String[] markers, Timestamp timestamp) {
        return replacedString.replace(markers[0], Long.toString(timestamp.getTime())).replace(markers[1], String.format("%02d", timestamp.toLocalDateTime().getDayOfMonth())).replace(markers[2], String.format("%02d", timestamp.toLocalDateTime().getMonthValue())).replace(markers[3], String.format("%02d", timestamp.toLocalDateTime().getYear()).substring(2)).replace(markers[4], Integer.toString(timestamp.toLocalDateTime().getYear())).replace(markers[5], String.format("%02d", timestamp.toLocalDateTime().getHour())).replace(markers[6], String.format("%02d", timestamp.toLocalDateTime().getMinute())).replace(markers[7], String.format("%02d", timestamp.toLocalDateTime().getSecond())).replace(markers[8], String.format("%03d", timestamp.toLocalDateTime().getNano() / 1000000));
    }

    public static String injectLastSuccessfulExecutionTime(String replacedString, ScheduledTaskInstanceInfo scheduledTaskInstanceInfo) {
        Timestamp timestamp;
        String[] markers;
        block5: {
            block4: {
                markers = new String[]{"{timestamp}", "{DD}", "{MM}", "{YY}", "{YYYY}", "{hh}", "{mm}", "{ss}", "{nnn}"};
                if (StringUtils.isBlank((CharSequence)replacedString)) break block4;
                if (!Arrays.stream(markers).noneMatch(replacedString::contains)) break block5;
            }
            return replacedString;
        }
        SQLFinder finder = FinderFactory.getSQLFinder();
        SQLBuilder builder = new SQLBuilder();
        builder.setQuery("SELECT startdate FROM pm_scheduled_tasks_history");
        builder.addFilter((SQLFilter)new SimpleSQLFilter("taskid", (Object)scheduledTaskInstanceInfo.getId()));
        builder.addFilter((SQLFilter)new SimpleSQLFilter("success", (Object)true));
        builder.addSorter(new Sorter("startdate", SortDirection.DESC));
        builder.addScalar("startdate", StandardBasicTypes.TIMESTAMP);
        CountedResult data = finder.find(builder, Integer.valueOf(0), Integer.valueOf(1));
        try {
            timestamp = (Timestamp)((Map)data.getData().get(0)).get("startdate");
        }
        catch (IndexOutOfBoundsException e) {
            timestamp = new Timestamp(0L);
        }
        return PropertyInjector.replaceTime(replacedString, markers, timestamp);
    }
}

