/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.money.servlet;

import com.suncode.plugin.tools.money.service.VerbalDescriptionService;
import java.math.BigDecimal;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class MoneyTranslateController {
    private static final Logger log = LoggerFactory.getLogger(MoneyTranslateController.class);
    @Autowired
    private VerbalDescriptionService moneyTranslatorService;

    @RequestMapping(value={"/money"}, method={RequestMethod.GET})
    @ResponseBody
    public String translate(@RequestParam(value="money") String money) {
        try {
            return URLEncoder.encode(this.moneyTranslatorService.translateToPLNMoney(new BigDecimal(money)), "UTF-8");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "B\u0142\u0105d t\u0142umaczenia";
        }
    }
}

