/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.money.duals;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.money.exceptions.VariableException;
import com.suncode.plugin.tools.money.service.VerbalDescriptionService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import com.suncode.pwfl.workflow.variable.Variable;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;

@Application
@VariableSetter
public class VerbalDescriptionMoneyDual {
    @Autowired
    private VerbalDescriptionService verbalDescriptionService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("tools.verbal-description-money.dual")).name("tools.verbal-description-money.name")).description("tools.verbal-description-money.desc")).category(new Category[]{Categories.TOOLS})).icon((Icon)SilkIconPack.MONEY)).parameter().id("amounts").name("tools.verbal-description-money.amount.name").description("tools.verbal-description-money.amount.desc").type((Type)Types.FLOAT_ARRAY).create()).parameter().id("verbalDescriptionVar").name("tools.verbal-description-money.verbal-description.name").description("tools.verbal-description-money.verbal-description.desc").type((Type)Types.VARIABLE).create();
    }

    public void execute(@Param Double[] amounts, @Param Variable verbalDescriptionVar) {
        this.run(amounts, verbalDescriptionVar);
    }

    public void set(@Param Double[] amounts, @Param Variable verbalDescriptionVar) {
        this.run(amounts, verbalDescriptionVar);
    }

    private void run(Double[] amounts, Variable verbalDescriptionVar) {
        List<String> descriptions = Stream.of(amounts).map(amount -> this.verbalDescriptionService.translateToPLNMoney(new BigDecimal((double)amount))).collect(Collectors.toList());
        if (verbalDescriptionVar.isArray()) {
            verbalDescriptionVar.setValue((Object)descriptions.toArray(new String[0]));
        } else {
            if (descriptions.size() > 1) {
                throw new VariableException(verbalDescriptionVar);
            }
            if (!descriptions.isEmpty()) {
                verbalDescriptionVar.setValue(descriptions.get(0));
            } else {
                verbalDescriptionVar.setValue((Object)"");
            }
        }
    }
}

