/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.handler.filebackup;

import com.plusmpm.enhydra.shark.transaction.WfActivityTransaction;
import com.plusmpm.util.documents.DocumentEvent;
import com.plusmpm.util.documents.handlers.DocumentEventHandler;
import com.suncode.plugin.tools.exception.FileCopyingException;
import com.suncode.plugin.tools.service.CopyingFileService;
import com.suncode.plugin.tools.service.CopyingFileServiceImpl;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.util.ServiceFactory;
import java.time.LocalDate;

public class FileBackupHandler
implements DocumentEventHandler {
    private final String[] markers = new String[]{"{DD}", "{MM}", "{YYYY}", "{DOC_CLASS_NAME}"};
    private final DocumentService documentService = ServiceFactory.getDocumentService();
    private final CopyingFileService copyingFileService = new CopyingFileServiceImpl();

    public FileBackupHandler(String processId) {
    }

    private String resolveDestinationPath(String uncPath, String documentClassName) {
        LocalDate currentDate = LocalDate.now();
        return uncPath.replace(this.markers[0], String.format("%02d", currentDate.getDayOfMonth())).replace(this.markers[1], String.format("%02d", currentDate.getMonthValue())).replace(this.markers[2], String.format("%02d", currentDate.getYear())).replace(this.markers[3], documentClassName);
    }

    public void handleEvent(WfActivityTransaction wfActivityTransaction, DocumentEvent documentEvent) throws FileCopyingException {
        String destination = SystemProperties.getString((String)"Destination.Path");
        Boolean overwrite = SystemProperties.getBoolean((String)"Overwrite");
        Long fileId = documentEvent.getDocument().getLFileId();
        String sourcePath = this.documentService.getDocument(fileId).getFile().getFullPath();
        String filename = this.documentService.getDocument(fileId).getFile().getSystemFileName();
        String documentClassName = documentEvent.getDocument().getLDocClassName();
        String destinationPath = this.resolveDestinationPath(destination, documentClassName);
        if (!this.copyingFileService.copyDocument(sourcePath, destinationPath + filename, overwrite)) {
            throw new FileCopyingException("Error copying file!");
        }
    }
}

