/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.exception.util;

import com.suncode.plugin.tools.exception.CancelTaskException;
import com.suncode.plugin.tools.exception.TimeoutException;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import org.joda.time.DateTime;

public class ExceptionUtils {
    public static void checkTaskCancellation(CancelationHandler cancellation) throws CancelTaskException {
        if (cancellation.isCanceled().booleanValue()) {
            throw new CancelTaskException("Cancelled by user");
        }
    }

    public static void checkIsTimeout(DateTime startDate, int maximumRunningHour) {
        if (DateTime.now().getMillis() - startDate.plusHours(Math.abs(maximumRunningHour)).getMillis() > 0L) {
            throw new TimeoutException();
        }
    }

    public static String getStackTrace(Exception e, Integer maxLength) {
        String stackTrace = org.apache.commons.lang3.exception.ExceptionUtils.getStackTrace((Throwable)e);
        if (maxLength == null || maxLength < 0) {
            maxLength = stackTrace.length();
        }
        return stackTrace.substring(0, Math.min(stackTrace.length(), maxLength));
    }
}

