/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.email;

import com.suncode.cuf.mail.SystemMailConfiguration;
import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.email.EmailAddresses;
import com.suncode.plugin.tools.email.EmailEngine;
import com.suncode.plugin.tools.email.EmailHelper;
import com.suncode.plugin.tools.email.dto.AddressesDto;
import com.suncode.plugin.tools.email.dto.SendReportDto;
import com.suncode.pwfl.administration.email.EmailAttachment;
import com.suncode.pwfl.administration.email.EmailMessage;
import com.suncode.pwfl.administration.email.configuration.EmailConfiguration;
import com.suncode.pwfl.administration.email.configuration.EmailConfigurationService;
import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.process.ProcessService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class SendAdvanceEmail {
    private static final Logger log = LoggerFactory.getLogger(SendAdvanceEmail.class);
    @Autowired
    private EmailConfigurationService emailConfigurationService;
    @Autowired
    private EmailEngine emailEngine;
    @Autowired
    private ProcessService processService;
    @Autowired
    private EmailAddresses emailAddresses;
    @Autowired
    private EmailHelper emailHelper;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("send-advance-email-app")).name("application.send-advance-email-app.name")).description("application.send-advance-email-app.desc")).category(new Category[]{Categories.TOOLS_EMAIL})).icon((Icon)DivanteIcon.MAIL2)).parameter().id("email-config-id").name("application.send-advance-email-app.param.email-config-id.name").description("application.send-advance-email-app.param.email-config-id.desc").type((Type)Types.STRING).optional().create()).parameter().id("subject").name("application.send-advance-email-app.param.subject.name").description("application.send-advance-email-app.param.subject.desc").type((Type)Types.STRING).create()).parameter().id("direct-addresses").name("application.send-advance-email-app.param.direct-addresses.name").description("application.send-advance-email-app.param.direct-addresses.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("copy-addresses").name("application.send-advance-email-app.param.copy-addresses.name").description("application.send-advance-email-app.param.copy-addresses.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("hidden-copy-addresses").name("application.send-advance-email-app.param.hidden-copy-addresses.name").description("application.send-advance-email-app.param.hidden-copy-addresses.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("send-as-one").name("application.send-advance-email-app.param.send-as-one.name").description("application.send-advance-email-app.param.send-as-one.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("is-tempalte-name").name("application.send-advance-email-app.param.is-tempalte-name.name").description("application.send-advance-email-app.param.is-tempalte-name.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).optional().create()).parameter().id("template-path").name("application.send-advance-email-app.param.template-path.name").description("application.send-advance-email-app.param.template-path.desc").type((Type)Types.STRING).defaultValue((Object)"c:\\szablon.html").create()).parameter().id("variables-key").name("application.send-advance-email-app.param.variables-key.name").description("application.send-advance-email-app.param.variables-key.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("variables-value").name("application.send-advance-email-app.param.variables-value.name").description("application.send-advance-email-app.param.variables-value.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("info-success-send").name("application.send-advance-email-app.param.info-success-send.name").description("application.send-advance-email-app.param.info-success-send.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("info-failure-send").name("application.send-advance-email-app.param.info-failure-send.name").description("application.send-advance-email-app.param.info-failure-send.desc").type((Type)Types.VARIABLE).optional().create()).parameter().id("comment-report").name("application.send-advance-email-app.param.comment-report.name").description("application.send-advance-email-app.param.comment-report.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("add-attachments").name("application.email.param.add-attachments.name").description("application.email.param.add-attachments.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("document-source").name("application.email.param.document-source.name").description("application.email.param.document-source.description").type((Type)Types.STRING).defaultValue((Object)"documentClass").create()).parameter().id("file-id").name("application.email.param.file-id.name").description("application.email.param.file-id.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("documets-class-id").name("application.email.param.documets-class-id.name").description("application.email.param.documets-class-id.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("prefix").name("application.email.param.prefix.name").description("application.email.param.prefix.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("filename-regexp").name("application.email.param.filename-regexp.name").description("application.email.param.filename-regexp.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("save-content").name("application.email.param.save-content.name").description("application.email.param.save-content.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("save-doc-class-name").name("application.email.param.save-doc-class-name.name").description("application.email.param.save-doc-class-name.desc").type((Type)Types.STRING).optional().create()).parameter().id("save-filename").name("application.email.param.save-filename.name").description("application.email.param.save-filename.desc").type((Type)Types.STRING).optional().create()).parameter().id("save-description").name("application.email.param.save-description.name").description("application.email.param.save-description.desc").type((Type)Types.STRING).optional().create()).parameter().id("save-atach-to-process").name("application.email.param.save-atach-to-process.name").description("application.email.param.save-atach-to-process.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create()).parameter().id("save-add-header").name("application.email.param.save-add-header.name").description("application.email.param.save-add-header.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("save-as-new-version").name("application.email.param.save-as-new-version.name").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.FALSE).create()).parameter().id("index-name").name("application.email.param.index-name.name").description("application.email.param.index-name.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("index-value").name("application.email.param.index-value.name").description("application.email.param.index-value.desc").type((Type)Types.STRING_ARRAY).optional().create()).parameter().id("save-cust-header-template-path").name("application.email.param.save-cust-header-template-path.name").description("application.email.param.save-cust-header-template-path.desc").type((Type)Types.STRING).optional().create()).parameter().id("send-language").name("application.send-advance-email-app.param.send-language.name").description("application.send-advance-email-app.param.send-language.desc").type((Type)Types.STRING).defaultValue((Object)"PL").optional().create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(@Param(value="email-config-id") String emailConfigId, @Param(value="subject") String subject, @Param(value="is-tempalte-name") Boolean isTemplateName, @Param(value="template-path") String templatePathOrName, @Param(value="variables-key") String[] variablesKey, @Param(value="variables-value") String[] variablesValue, @Param(value="direct-addresses") String[] directAddresses, @Param(value="copy-addresses") String[] copyAddresses, @Param(value="hidden-copy-addresses") String[] hiddenCopyAddresses, @Param(value="send-as-one") Boolean sendAsOne, @Param(value="info-success-send") Variable successInfo, @Param(value="info-failure-send") Variable failureInfo, @Param(value="comment-report") Boolean isCommentReportOn, @Param(value="add-attachments") Boolean addAttachments, @Param(value="save-content") Boolean saveContent, @Param(value="save-doc-class-name") String saveDocClassName, @Param(value="save-filename") String saveFileName, @Param(value="save-description") String saveDescription, @Param(value="save-add-header") Boolean saveAddHeader, @Param(value="save-as-new-version") Boolean saveAsNewVersion, @Param(value="save-cust-header-template-path") String customHeaderTemplatePath, @Param(value="document-source") String documentSource, @Param(value="file-id") String[] fileId, @Param(value="send-language") String sendLanguage, @PairedParam(key="documets-class-id", value="prefix") Map<String, String> docClassAndPrefix, @PairedParam(key="documets-class-id", value="filename-regexp") Map<String, String> docClassAndFileNameRegexp, @PairedParam(key="index-name", value="index-value") Map<String, String> saveNewIndexes, ActivityContextMap activityContextMap, UserInfo userInfo, Translator translator) throws AcceptanceException {
        String content;
        File template;
        log.debug("Email parameters");
        log.debug("Subject: " + subject);
        log.debug("Template (path or name): " + templatePathOrName);
        log.debug("Direct addresses (TO): " + Arrays.toString(directAddresses));
        log.debug("Copy addresses (CC): " + Arrays.toString(copyAddresses));
        log.debug("Hidden copy addresses (BCC): " + Arrays.toString(hiddenCopyAddresses));
        log.debug("Sending as one: " + sendAsOne);
        log.debug("Send language: " + sendLanguage);
        String processDefID = this.processService.getProcess(activityContextMap.getProcessId(), new String[]{"processDefinition"}).getProcessDefinition().getProcessDefinitionId();
        EmailConfiguration emailConfiguration = StringUtils.isNotEmpty((CharSequence)emailConfigId) ? (EmailConfiguration)this.emailConfigurationService.get((Serializable)Long.valueOf(emailConfigId), new String[]{"oauth2Connection"}) : SystemMailConfiguration.getInstance().getEmailConfiguration();
        EmailMessage.EmailMessageBuilder emailMessageBuilder = EmailMessage.builder();
        if (Boolean.TRUE.equals(isTemplateName)) {
            Optional<String> path = this.emailEngine.getTemplatePath(templatePathOrName, processDefID);
            if (!path.isPresent()) throw new AcceptanceException("Template name : " + templatePathOrName + " not found in processDefId:" + processDefID);
            template = new File(path.get().trim());
        } else {
            template = new File(templatePathOrName.trim());
        }
        if (Boolean.TRUE.equals(addAttachments)) {
            List<EmailAttachment> emailAttachments = this.emailHelper.createEmailAttachments(documentSource, activityContextMap, docClassAndPrefix, docClassAndFileNameRegexp, fileId);
            emailMessageBuilder.attachments(emailAttachments);
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        if (variablesKey != null && variablesValue != null && variablesKey.length == variablesValue.length) {
            for (int index = 0; index < variablesKey.length; ++index) {
                if (variablesKey[index] == null) continue;
                vars.put(variablesKey[index], variablesValue[index] != null ? variablesValue[index] : "");
            }
        } else {
            log.debug("Lista nazw zmiennych i lista warto\u015bci s\u0105 r\u00f3\u017cnej d\u0142ugo\u015bci lub nie zosta\u0142y uzupe\u0142nione");
        }
        try {
            content = new String(Files.readAllBytes(template.toPath()));
        }
        catch (IOException e) {
            throw new AcceptanceException(String.format("Could not read template from path %s.", template.toPath()), (Throwable)e);
        }
        emailMessageBuilder.params(vars);
        content = this.emailEngine.replaceExpressions(content, activityContextMap, userInfo, sendLanguage);
        subject = this.emailEngine.replaceExpressions(subject, activityContextMap, userInfo, sendLanguage);
        emailMessageBuilder.subject(subject);
        emailMessageBuilder.content(content);
        try {
            AddressesDto addresses = this.emailAddresses.buildEmailAddresses(directAddresses, copyAddresses, hiddenCopyAddresses, sendAsOne, activityContextMap);
            EmailMessage emailMessage = emailMessageBuilder.build();
            SendReportDto sendReport = this.send(emailConfiguration, emailMessage, addresses, addAttachments, documentSource, activityContextMap, docClassAndPrefix, docClassAndFileNameRegexp, fileId);
            this.emailEngine.logSendReport(sendReport);
            List<String> failedEmails = sendReport.getFailedEmails();
            List<String> successEmails = sendReport.getSuccessfulEmails();
            if (successInfo != null) {
                this.emailEngine.setFeedbackVariable(successInfo, successEmails);
            }
            if (failureInfo != null) {
                this.emailEngine.setFeedbackVariable(failureInfo, failedEmails);
            }
            if (Boolean.TRUE.equals(isCommentReportOn)) {
                this.emailEngine.commentResult(activityContextMap, sendReport, addresses);
            }
            if (!failedEmails.isEmpty()) {
                throw new AcceptanceException(translator.getMessage("errors.failedToSendEmails", new Object[]{failedEmails.toString()}));
            }
            if (!Boolean.TRUE.equals(saveContent)) return;
            String emailContent = emailMessage.getContent();
            if (emailContent != null && !vars.isEmpty()) {
                for (Map.Entry entry : vars.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = entry.getValue() != null ? (String)entry.getValue() : "";
                    emailContent = emailContent.replace("@" + key + "@", value);
                }
                emailMessage.setContent(emailContent);
            }
            this.emailEngine.addHTMLDocumentToProcess(saveDocClassName, saveFileName, saveDescription, saveAddHeader, saveAsNewVersion, customHeaderTemplatePath, saveNewIndexes, activityContextMap, userInfo, emailConfiguration, addresses, emailMessage);
            return;
        }
        catch (Exception e) {
            throw new AcceptanceException((Throwable)e);
        }
    }

    private SendReportDto send(EmailConfiguration emailConfiguration, EmailMessage emailMessage, AddressesDto addresses, Boolean addAttachments, String documentSource, ActivityContextMap activityContextMap, Map<String, String> docClassAndPrefix, Map<String, String> docClassAndFileNameRegexp, String[] fileId) {
        SendReportDto report = new SendReportDto();
        List<String> directAddresses = addresses.getDirectAddresses().getValidAddresses();
        List<String> copyAddresses = addresses.getCopyAddresses().getValidAddresses();
        List<String> hiddenCopyAddresses = addresses.getHiddenCopyAddresses().getValidAddresses();
        if (addresses.isSendAsOne()) {
            this.emailHelper.sendEmail(emailConfiguration, emailMessage, directAddresses, copyAddresses, hiddenCopyAddresses, report, addAttachments);
        } else {
            boolean isFirstEmail = true;
            for (String directAddress : directAddresses) {
                this.emailHelper.sendEmail(emailConfiguration, emailMessage, Collections.singletonList(directAddress), copyAddresses, hiddenCopyAddresses, report, addAttachments, documentSource, activityContextMap, docClassAndPrefix, docClassAndFileNameRegexp, fileId, isFirstEmail);
                isFirstEmail = false;
            }
        }
        return report;
    }
}

