/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.email;

import com.beust.jcommander.internal.Lists;
import com.suncode.cuf.mail.Addresses;
import com.suncode.plugin.tools.email.EmailAddresses;
import com.suncode.plugin.tools.email.dto.AddressesDto;
import com.suncode.plugin.tools.email.dto.AddressesValidationDto;
import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.administration.structure.Position;
import com.suncode.pwfl.administration.structure.PositionFinder;
import com.suncode.pwfl.administration.structure.role.RoleFilter;
import com.suncode.pwfl.administration.user.User;
import com.suncode.pwfl.administration.user.UserFinder;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.workflow.activity.Activity;
import com.suncode.pwfl.workflow.activity.ActivityContextMap;
import com.suncode.pwfl.workflow.activity.ActivityEntity;
import com.suncode.pwfl.workflow.activity.ActivityFinder;
import com.suncode.pwfl.workflow.activity.ActivityService;
import com.suncode.pwfl.workflow.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailAddresesImpl
implements EmailAddresses {
    private static final Logger log = LoggerFactory.getLogger(EmailAddresesImpl.class);
    private static final String EMAIL_REGEX = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,}$";
    @Autowired
    private ActivityFinder activityFinder;
    @Autowired
    private UserService userService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private PositionFinder positionFinder;
    @Autowired
    private UserFinder userFinder;
    @Autowired
    private OrganizationalUnitFinder ouFinder;

    @Override
    public AddressesDto buildEmailAddresses(String[] directAddresses, String[] copyAddresses, String[] hiddenCopyAddresses, Boolean sendAsOne, ActivityContextMap activityContext) {
        List<String> directAddressesListTemp = this.parseAddresses(directAddresses);
        List<String> copyAddressesListTemp = this.parseAddresses(copyAddresses);
        List<String> hiddenCopyAddressesListTemp = this.parseAddresses(hiddenCopyAddresses);
        return AddressesDto.builder().directAddresses(this.decodeEmailAddress(directAddressesListTemp, activityContext)).copyAddresses(this.decodeEmailAddress(copyAddressesListTemp, activityContext)).hiddenCopyAddresses(this.decodeEmailAddress(hiddenCopyAddressesListTemp, activityContext)).sendAsOne(sendAsOne).build();
    }

    private List<String> parseAddresses(String[] directAddresses) {
        ArrayList<String> addresses = new ArrayList<String>();
        for (String str : directAddresses) {
            if (StringUtils.isBlank((CharSequence)str)) continue;
            addresses.addAll(Arrays.asList(StringUtils.split((String)str, (String)";,")));
        }
        return addresses;
    }

    @Override
    public Addresses buildAddresses(String[] directAddresses, String[] copyAddresses, String[] hiddenCopyAddresses, Boolean sendAsOne, ActivityContextMap activityContext) {
        List<String> directAddressesListTemp = this.parseAddresses(directAddresses);
        List<String> copyAddressesListTemp = this.parseAddresses(copyAddresses);
        List<String> hiddenCopyAddressesListTemp = this.parseAddresses(hiddenCopyAddresses);
        return new Addresses(this.decodeEmailAddress(directAddressesListTemp, activityContext).getValidAddresses(), this.decodeEmailAddress(copyAddressesListTemp, activityContext).getValidAddresses(), this.decodeEmailAddress(hiddenCopyAddressesListTemp, activityContext).getValidAddresses(), sendAsOne.booleanValue());
    }

    private AddressesValidationDto decodeEmailAddress(List<String> macroList, ActivityContextMap activityContext) {
        log.debug("\nDecode email\n\n");
        Pattern patternEmail = Pattern.compile(EMAIL_REGEX, 2);
        HashSet<String> validAddresses = new HashSet<String>();
        HashSet<String> invalidAddresses = new HashSet<String>();
        for (String macro : macroList) {
            String strMacro;
            if (patternEmail.matcher(macro).find()) {
                validAddresses.add(macro);
                continue;
            }
            if (macro.matches("^ROLE_.+")) {
                strMacro = macro.substring(5);
                this.getEmailByRole(strMacro, validAddresses);
                continue;
            }
            if (macro.matches("^USER_.+")) {
                strMacro = macro.substring(5);
                this.getEmailByUser(strMacro, validAddresses);
                continue;
            }
            if (macro.matches("^GROUP_.+")) {
                strMacro = macro.substring(6);
                this.getEmailByGroup(strMacro, validAddresses);
                continue;
            }
            if (macro.matches("^POSITION_BY_NAME_.+")) {
                strMacro = macro.substring(17);
                this.getEmailByPositionByName(strMacro, validAddresses);
                continue;
            }
            if (macro.matches("^POSITION_BY_SYMBOL_.+")) {
                strMacro = macro.substring(19);
                this.getEmailByPositionBySymbol(strMacro, validAddresses);
                continue;
            }
            if (macro.matches("^EXECUTOR_.+")) {
                strMacro = macro.substring(9);
                this.getEmailByExecutor(strMacro, validAddresses, activityContext);
                continue;
            }
            if (macro.matches("^OU_BY_NAME_.+")) {
                strMacro = macro.substring(11);
                this.getEmailByOuByName(strMacro, validAddresses);
                continue;
            }
            if (macro.matches("^OU_BY_SYMBOL_.+")) {
                strMacro = macro.substring(13);
                this.getEmailByOuBySymbol(strMacro, validAddresses);
                continue;
            }
            if (macro.matches("^VAR_EMAIL_.+")) {
                strMacro = macro.substring(10);
                this.getEmailByVarEmail(strMacro, validAddresses, activityContext);
                continue;
            }
            if (macro.matches("^VAR_USER_.+")) {
                strMacro = macro.substring(9);
                this.getEmailByVarUser(strMacro, validAddresses, activityContext);
                continue;
            }
            log.info("Wrong comand or email:\t" + macro);
            invalidAddresses.add(macro);
        }
        return AddressesValidationDto.builder().validAddresses(Lists.newArrayList(validAddresses)).invalidAddresses(Lists.newArrayList(invalidAddresses)).build();
    }

    private void getEmailByVarUser(String idVariable, Set<String> result, ActivityContextMap activityContext) {
        if (activityContext != null) {
            Variable var = activityContext.getVariable(idVariable);
            try {
                if (var.isArray()) {
                    String[] tableUsers;
                    for (String userName : tableUsers = (String[])var.getValue()) {
                        this.getEmailByUser(userName, result);
                    }
                }
                String userName = (String)var.getValue();
                for (String string : userName.split(";")) {
                    this.getEmailByUser(string, result);
                }
            }
            catch (Exception e) {
                log.debug(e.getClass().getName() + " : " + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            log.debug("No activityContextMap set");
        }
    }

    private void getEmailByVarEmail(String idVarEmail, Set<String> result, ActivityContextMap activityContext) {
        Pattern paternEmail = Pattern.compile(EMAIL_REGEX, 2);
        if (activityContext != null) {
            Variable var = activityContext.getVariable(idVarEmail);
            try {
                if (var.isArray()) {
                    String[] table;
                    for (String string : table = (String[])var.getValue()) {
                        if (!paternEmail.matcher(string).find()) continue;
                        result.add(string);
                    }
                }
                String email = (String)var.getValue();
                for (String string : email.split(";")) {
                    if (!paternEmail.matcher(string).find()) continue;
                    result.add(string);
                }
            }
            catch (Exception e) {
                log.debug(e.getClass().getName() + " : " + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
        } else {
            log.debug("No activityContextMap set");
        }
    }

    private void getEmailByOuBySymbol(String ouSymbol, Set<String> result) {
        log.debug("Find Email by OU Symbol " + ouSymbol);
        ArrayList users = new ArrayList();
        log.debug("Get users for OU Symbol");
        try {
            users.addAll(this.userFinder.findByOU(ouSymbol));
        }
        catch (Exception e) {
            log.debug(e.getClass().getName() + " : " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        log.debug("find users " + users.size());
        for (User user : users) {
            if (user.getEmail() != null && !user.getEmail().isEmpty()) {
                result.add(user.getEmail());
            }
            log.debug(user.getFullName() + " : " + user.getEmail());
        }
    }

    private void getEmailByOuByName(String ouName, Set<String> result) {
        log.debug("Find Email by OU Name " + ouName);
        ArrayList users = new ArrayList();
        log.debug("Get users for group");
        try {
            List ouList = this.ouFinder.findByName(ouName, new String[0]);
            for (OrganizationalUnit organizationalUnit : ouList) {
                String ouSymbol = organizationalUnit.getSymbol();
                users.addAll(this.userFinder.findByOU(ouSymbol));
            }
        }
        catch (Exception e) {
            log.debug(e.getClass().getName() + " : " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        log.debug("find users " + users.size());
        for (User user : users) {
            if (user.getEmail() != null && !user.getEmail().isEmpty()) {
                result.add(user.getEmail());
            }
            log.debug(user.getFullName() + " : " + user.getEmail());
        }
    }

    private void getEmailByExecutor(String idActivityDef, Set<String> result, ActivityContextMap activityContext) {
        User user;
        ActivityEntity activity;
        String sProcessId = activityContext.getProcessId();
        List listActivity = this.activityFinder.findByProcessId(sProcessId, new String[0]);
        String sActivityId = null;
        for (Activity activity2 : listActivity) {
            if (!activity2.getActivityDefinitionId().equals(idActivityDef)) continue;
            sActivityId = activity2.getActivityId();
            break;
        }
        if ((activity = (ActivityEntity)this.activityService.getActivity(sProcessId, sActivityId, new String[0])) != null && (user = this.userService.getUser(activity.getResourceId(), new String[0])) != null && user.getEmail() != null && !user.getEmail().isEmpty()) {
            result.add(user.getEmail());
        }
    }

    private void getEmailByPositionBySymbol(String positionSymbol, Set<String> result) {
        User user;
        Position positionUser = this.positionFinder.findBySymbol(positionSymbol, new String[]{"user"});
        if (positionUser != null && (user = positionUser.getUser()) != null && user.getEmail() != null && !user.getEmail().isEmpty()) {
            result.add(user.getEmail());
        }
    }

    private void getEmailByPositionByName(String positionName, Set<String> result) {
        List positonUsers = this.positionFinder.findByName(positionName, new String[]{"user"});
        for (Position position : positonUsers) {
            User user = position.getUser();
            if (user == null || user.getEmail() == null || user.getEmail().isEmpty()) continue;
            result.add(user.getEmail());
        }
    }

    private void getEmailByGroup(String group, Set<String> result) {
        log.debug("Find Email by Group " + group);
        List users = new ArrayList();
        log.debug("Get users for group");
        try {
            users = this.userFinder.findByGroup(group);
        }
        catch (Exception e) {
            log.debug(e.getClass().getName() + " : " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        log.debug("find group " + users.size());
        for (User user : users) {
            if (user.getEmail() != null && !user.getEmail().isEmpty()) {
                result.add(user.getEmail());
            }
            log.debug(user.getFullName() + " : " + user.getEmail());
        }
    }

    private void getEmailByUser(String userName, Set<String> result) {
        log.debug("Find Email by User " + userName);
        User user = this.userFinder.findByUserName(userName, new String[0]);
        if (user != null && user.getEmail() != null && !user.getEmail().isEmpty()) {
            result.add(user.getEmail());
        }
    }

    private void getEmailByRole(String role, Set<String> result) {
        log.debug("Find Email by Role " + role);
        ArrayList<RoleFilter> filters = new ArrayList<RoleFilter>();
        RoleFilter tempRole = new RoleFilter();
        tempRole.setRoleIds(Arrays.asList(role));
        filters.add(tempRole);
        List users = new ArrayList();
        log.debug("Get users for role");
        try {
            users = this.userFinder.findByRoles(filters);
        }
        catch (Exception e) {
            log.debug(e.getClass().getName() + " : " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
        log.debug("find users " + users.size());
        for (User user : users) {
            if (user.getEmail() != null && !user.getEmail().isEmpty()) {
                result.add(user.getEmail());
            }
            log.debug(user.getFullName() + " : " + user.getEmail());
        }
    }
}

