/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.dual;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.service.DeletingFileService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
public class DeleteFilesFromDiskDual {
    private static final Logger log = LoggerFactory.getLogger(DeleteFilesFromDiskDual.class);
    @Autowired
    private DeletingFileService deletingFileService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("tools.delete-files-from-disk-dual")).name("tools.delete-files-from-disk-dual.name")).description("tools.delete-files-from-disk-dual.desc")).category(new Category[]{Categories.TOOLS})).icon((Icon)SilkIconPack.APPLICATION_DELETE)).parameter().id("directory").name("tools.delete-files-from-disk-dual.param.directory.name").description("tools.delete-files-from-disk-dual.param.directory.desc").type((Type)Types.STRING).defaultValue((Object)FileSystems.getDefault().getSeparator()).create()).parameter().id("filename").name("tools.delete-files-from-disk-dual.param.filename.name").description("tools.delete-files-from-disk-dual.param.filename.desc").type((Type)Types.STRING).create()).parameter().id("searchInSubdirectories").name("tools.delete-files-from-disk-dual.param.searchInSubdirectories.name").description("tools.delete-files-from-disk-dual.param.searchInSubdirectories.desc").type((Type)Types.BOOLEAN).create();
    }

    public void execute(Translator translator, @Param String directory, @Param String filename, @Param Boolean searchInSubdirectories) throws AcceptanceException {
        this.run(translator, directory, filename, searchInSubdirectories);
    }

    public void set(Translator translator, @Param String directory, @Param String filename, @Param Boolean searchInSubdirectories) throws AcceptanceException {
        this.run(translator, directory, filename, searchInSubdirectories);
    }

    private void run(Translator translator, String directory, String filename, Boolean searchInSubdirectories) throws AcceptanceException {
        try {
            String resolvedRegex = this.resolveRegex(filename);
            String resolvedDirectory = this.resolveDirectory(directory);
            String errorMessage = translator.getMessage("tools.delete-files-from-disk-dual.message.exception.fileDeletingException");
            log.info("Resolved regex: " + resolvedRegex);
            log.info("Resolved directory: " + resolvedDirectory);
            this.deletingFileService.deleteFiles(resolvedDirectory, resolvedRegex, searchInSubdirectories, errorMessage);
        }
        catch (Exception e) {
            throw new AcceptanceException(translator.getMessage("tools.delete-files-from-disk-dual.message.errorLabel") + " " + translator.getMessage("tools.delete-files-from-disk-dual.name") + ". " + translator.getMessage("tools.delete-files-from-disk-dual.message.errorMessageLabel") + " " + e.getMessage());
        }
    }

    private String resolveRegex(String userRegex) {
        Assert.isTrue((!userRegex.isEmpty() ? 1 : 0) != 0, (String)"Filename is empty");
        return userRegex;
    }

    private String resolveDirectory(String userDirectory) throws IOException, IllegalArgumentException {
        String normalizedPath;
        String homePath = System.getProperty("plusworkflow.home");
        File path = new File(homePath, normalizedPath = Paths.get(userDirectory, new String[0]).normalize().toString());
        if (!path.getCanonicalPath().startsWith(homePath)) {
            throw new IllegalArgumentException("Directory path not allowed!");
        }
        return homePath + normalizedPath;
    }
}

