/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.dual;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileCipherService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.PairedParam;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.AcceptanceContext;
import com.suncode.pwfl.workflow.WorkflowContext;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.variablesetter.annotation.VariableSetter;
import com.suncode.pwfl.workflow.invocable.CommonDefinitionBuilder;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@VariableSetter
@ComponentsFormScript(value="scripts/dynamic-form-pwe/tools-decryption-of-attached-file-form.js")
public class DecryptionOfAttachedFilesDual {
    private static final Logger log = LoggerFactory.getLogger(DecryptionOfAttachedFilesDual.class);
    @Autowired
    private DocumentService documentService;
    @Autowired
    private FileService fileService;
    @Autowired
    private FileCipherService fileCipherService;
    @Autowired
    private FileFinder fileFinder;
    @Autowired
    private DocumentClassService docClassService;

    @Define
    public void definition(CommonDefinitionBuilder builder) {
        ((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)((CommonDefinitionBuilder)builder.id("tools.decryption-of-attached-file.dual")).name("tools.decryption-of-attached-file.name")).description("tools.decryption-of-attached-file.desc")).category(new Category[]{Categories.TOOLS})).icon((Icon)SilkIconPack.APPLICATION_KEY)).parameter().id("idsEncryptedFiles").name("tools.decryption-of-attached-file.idsEncryptedFiles.name").description("tools.decryption-of-attached-file.idsEncryptedFiles.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("encryptionKeys").name("tools.decryption-of-attached-file.encryptionKeys.name").description("tools.decryption-of-attached-file.encryptionKeys.desc").type((Type)Types.STRING_ARRAY).create()).parameter().id("cipherAlgorithm").name("tools.decryption-of-attached-file.cipherAlgorithm.name").description("tools.decryption-of-attached-file.cipherAlgorithm.desc").type((Type)Types.STRING).create()).parameter().id("destinationDocClass").name("tools.decryption-of-attached-file.destinationDocClass.name").description("tools.decryption-of-attached-file.destinationDocClass.desc").type((Type)Types.STRING).create()).parameter().id("attachToProcess").name("tools.decryption-of-attached-file.attachToProcess.name").description("tools.decryption-of-attached-file.attachToProcess.desc").type((Type)Types.BOOLEAN).defaultValue((Object)Boolean.TRUE).create();
    }

    public void execute(@Param String destinationDocClass, @Param String cipherAlgorithm, @Param Boolean attachToProcess, @PairedParam(key="idsEncryptedFiles", value="encryptionKeys") Map<String, String> encryptionKeyByFileIdMap, ApplicationContext context) {
        this.run(destinationDocClass, cipherAlgorithm, encryptionKeyByFileIdMap, attachToProcess, (WorkflowContext)context);
    }

    public void set(@Param String destinationDocClass, @Param String cipherAlgorithm, @Param Boolean attachToProcess, @PairedParam(key="idsEncryptedFiles", value="encryptionKeys") Map<String, String> encryptionKeyByFileIdMap, AcceptanceContext context) {
        this.run(destinationDocClass, cipherAlgorithm, encryptionKeyByFileIdMap, attachToProcess, (WorkflowContext)context);
    }

    private void run(String destinationDocClass, String cipherAlgorithm, Map<String, String> encryptionKeyByFileIdMap, Boolean attachToProcess, WorkflowContext context) {
        DocumentClass docClass = this.docClassService.getDocumentClass(destinationDocClass, new String[0]);
        Assert.notNull((Object)docClass, (String)("Incorrect parameter [destinationDocClass: " + destinationDocClass + " ]"));
        this.fileFinder.getDocumentsFromProcess(context.getProcessId(), new String[]{"documentClass"}).stream().filter(wfFile -> encryptionKeyByFileIdMap.containsKey(String.valueOf(wfFile.getId()))).forEach(wfFile -> {
            try (InputStream encryptedIS = this.fileService.getFileInputStream(Long.valueOf(wfFile.getId()));){
                String encryptionKey = (String)encryptionKeyByFileIdMap.get(String.valueOf(wfFile.getId()));
                InputStream unencryptedIS = this.fileCipherService.decryptFile(encryptedIS, cipherAlgorithm, encryptionKey);
                this.documentService.addDocument(this.buildDocumentDefinition(context.getProcessId(), (WfFile)wfFile, unencryptedIS, attachToProcess, docClass.getId()));
            }
            catch (Exception e) {
                log.error("Error file: " + wfFile.getFileName(), (Throwable)e);
                throw new RuntimeException("Error file: " + wfFile.getFileName(), e);
            }
        });
    }

    private DocumentDefinition buildDocumentDefinition(String processId, WfFile wfFile, InputStream unencryptedIS, Boolean attachToProcess, Long docClassId) {
        DocumentDefinition definition = new DocumentDefinition();
        definition.setDescription(wfFile.getDescription());
        definition.setFileName(wfFile.getFileName());
        definition.setInputStream(unencryptedIS);
        definition.setSaveAsNewVersion(false);
        definition.setUserName("admin");
        definition.setDocumentClassId(docClassId);
        if (attachToProcess.booleanValue()) {
            definition.setProcessId(processId);
        }
        return definition;
    }
}

