/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.docutils;

import com.suncode.plugin.tools.until.CreatorSettings;
import com.suncode.pwfl.administration.user.UserContext;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.IndexInfo;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.archive.WfFileVersion;
import com.suncode.pwfl.archive.util.DocumentDefinition;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class DocUtils {
    private static final Logger log = LoggerFactory.getLogger(DocUtils.class);
    @Autowired
    private DocumentService documentService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentClassService docClassService;
    @Autowired
    private FileService fileService;

    public void addDocumentAsNewVersion(WfDocument wfDocument, InputStream is, ApplicationContext appContext) throws Exception {
        String userName = UserContext.isActive() ? UserContext.current().getUser().getUserName() : CreatorSettings.getAdminUserName();
        DocumentDefinition docDefinition = this.createNewDocumentDefinition(wfDocument, is, appContext, userName);
        Long originalDocumentFileId = wfDocument.getFile().getId();
        String currentDocState = this.fileService.getVersionForFile(originalDocumentFileId).getState();
        if (currentDocState.equals(WfFileVersion.State.STATE_EDIT.toString())) {
            this.fileService.cancelCheckOut(originalDocumentFileId);
        }
        this.fileService.checkOut(originalDocumentFileId, userName);
        this.fileService.checkIn(docDefinition, originalDocumentFileId, "");
    }

    public List<WfDocument> getDocumentsFromProcessAndClass(String docClassName, ApplicationContext appContext) {
        ArrayList<WfDocument> docsFromProces = new ArrayList<WfDocument>();
        List tempList = this.documentFinder.getDocumentsFromActivity(appContext.getProcessId(), appContext.getActivityId(), new String[]{"documentClass"});
        DocumentClass docCass = this.docClassService.getDocumentClass(docClassName, new String[0]);
        for (WfDocument wfDocument : tempList) {
            if (!wfDocument.getDocumentClassId().equals(docCass.getId())) continue;
            docsFromProces.add(wfDocument);
        }
        return docsFromProces;
    }

    private DocumentDefinition createNewDocumentDefinition(WfDocument wfDocument, InputStream is, ApplicationContext appContext, String userName) throws FileNotFoundException {
        WfFile orgFile = wfDocument.getFile();
        DocumentDefinition definition = new DocumentDefinition();
        definition.setDocumentClassId(wfDocument.getDocumentClassId());
        definition.setFileName(orgFile.getFileName());
        definition.setDescription(orgFile.getDescription());
        definition.setUserName(userName);
        definition.setIndexes(this.getIdnexes(wfDocument));
        definition.setInputStream(is);
        definition.setProcessId(appContext.getProcessId());
        definition.setSaveAsNewVersion(true);
        return definition;
    }

    public WfDocument addNewWfDocument(String documentClasName, String fileName, String description, String processId, String userName, FileInputStream is, Map<String, String> saveNewIndexes, boolean saveAsNewVersion) {
        DocumentClass docCass = this.docClassService.getDocumentClass(documentClasName, new String[0]);
        Assert.notNull((Object)docCass, (String)("Document class " + documentClasName + " was not found"));
        DocumentDefinition definition = new DocumentDefinition();
        definition.setDocumentClassId(docCass.getId());
        definition.setFileName(fileName);
        definition.setInputStream((InputStream)is);
        definition.setProcessId(processId);
        definition.setUserName(StringUtils.isBlank((CharSequence)userName) ? "admin" : userName);
        definition.setDescription(description);
        definition.setIndexes(this.setIndexies(saveNewIndexes, documentClasName));
        definition.setSaveAsNewVersion(saveAsNewVersion);
        return this.documentService.addDocument(definition);
    }

    private Map<Long, Object> getIdnexes(WfDocument wfDocument) {
        HashMap<Long, Object> indexes = new HashMap<Long, Object>();
        for (IndexInfo indexInfo : wfDocument.getIndexes()) {
            indexes.put(indexInfo.getId(), indexInfo.getValue());
        }
        return indexes;
    }

    public Map<Long, Object> setIndexies(Map<String, String> indexNameAndValue, String documentClassName) {
        if (indexNameAndValue.isEmpty()) {
            return null;
        }
        HashMap<Long, Object> newIndexes = new HashMap<Long, Object>();
        DocumentClass docClass = this.docClassService.getDocumentClass(documentClassName, new String[]{"indexes"});
        Assert.notNull((Object)docClass, (String)("Document Class " + documentClassName + " was not found"));
        for (DocumentClassIndex documentClassIndex : docClass.getIndexes()) {
            String indexName = documentClassIndex.getName();
            if (!indexNameAndValue.containsKey(indexName)) continue;
            newIndexes.put(documentClassIndex.getId(), indexNameAndValue.get(indexName));
        }
        return newIndexes;
    }

    public void sortWfDocumentsByName(List<WfDocument> documents) {
        documents.sort(Comparator.comparing(o -> o.getFile().getFileName()));
    }

    public DocumentClass getDocumentClass(String docClassNameOrId) {
        try {
            DocumentClass docClass = this.docClassService.getDocumentClass(docClassNameOrId, new String[0]);
            return docClass == null ? (DocumentClass)this.docClassService.get((Serializable)Long.valueOf(Long.parseLong(docClassNameOrId))) : docClass;
        }
        catch (Exception nfe) {
            throw new Exception("DocumentClass " + docClassNameOrId + " not found", nfe);
        }
    }
}

