/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.calendar.autotask;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.pwfl.calendar.processReservation.ProcessReservationService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.variable.Variable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class AddResourceReservation {
    private static final Logger log = LoggerFactory.getLogger(AddResourceReservation.class);
    private static final String ID = "application.add-resource-reservation";
    @Autowired
    private ProcessReservationService processReservationService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.TOOLS_CALENDAR})).icon((Icon)SilkIconPack.ADD)).documentationLink("https://plusworkflow.helpdocsonline.com/{PROPROFS_LANGUAGE}add-resource-reservation")).parameter().id("processId").name(ID.concat(".param.processId.name")).type((Type)Types.STRING).create()).parameter().id("calendarResourceId").name(ID.concat(".param.calendarResourceId.name")).description(ID.concat(".param.calendarResourceId.desc")).type((Type)Types.INTEGER).create()).parameter().id("allDay").name(ID.concat(".param.allDay.name")).description(ID.concat(".param.allDay.desc")).type((Type)Types.BOOLEAN).create()).parameter().id("startDateTime").name(ID.concat(".param.startDateTime.name")).description(ID.concat(".param.startDateTime.desc")).type((Type)Types.DATETIME).create()).parameter().id("endDateTime").name(ID.concat(".param.endDateTime.name")).description(ID.concat(".param.endDateTime.desc")).type((Type)Types.DATETIME).create()).parameter().id("nameTemplate").name(ID.concat(".param.nameTemplate.name")).description(ID.concat(".param.nameTemplate.desc")).type((Type)Types.STRING).optional().create()).parameter().id("createdReservationId").name(ID.concat(".param.createdReservationId.name")).description(ID.concat(".param.createdReservationId.desc")).type((Type)Types.VARIABLE).optional().create();
    }

    public void execute(@Param(value="processId") String processId, @Param(value="calendarResourceId") Integer calendarResourceId, @Param(value="allDay") Boolean allDay, @Param(value="startDateTime") org.joda.time.LocalDateTime startDateTime, @Param(value="endDateTime") org.joda.time.LocalDateTime endDateTime, @Param(value="nameTemplate") String nameTemplate, @Param(value="createdReservationId") Variable createdReservationId) throws Exception {
        LocalDateTime endDateTimeValue;
        LocalDateTime startDateTimeValue;
        log.debug("Tworzenie rezerwacji zasobu");
        if (allDay.booleanValue()) {
            startDateTimeValue = LocalDateTime.of(startDateTime.getYear(), startDateTime.getMonthOfYear(), startDateTime.getDayOfMonth(), 0, 0, 0);
            endDateTimeValue = LocalDateTime.of(endDateTime.getYear(), endDateTime.getMonthOfYear(), endDateTime.getDayOfMonth(), 0, 0, 0);
        } else {
            startDateTimeValue = LocalDateTime.ofInstant(startDateTime.toDate().toInstant(), ZoneOffset.UTC);
            endDateTimeValue = LocalDateTime.ofInstant(endDateTime.toDate().toInstant(), ZoneOffset.UTC);
        }
        long reservationId = this.processReservationService.createReservation(processId, (long)calendarResourceId.intValue(), allDay.booleanValue(), startDateTimeValue, endDateTimeValue, nameTemplate);
        createdReservationId.setValue((Object)reservationId);
        log.debug("Utworzono rezerwacj\u0119 zasobu o id: {}", (Object)reservationId);
    }
}

