/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.autotask;

import com.plusmpm.CUF.util.extension.DocTemplates2Pdf.PrepeareDoc;
import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.exception.PrinterNotFoundException;
import com.suncode.plugin.tools.printdocument.enums.SupportedFileExtension;
import com.suncode.pwfl.administration.configuration.DefinedSystemParameter;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.DivanteIcon;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.workflow.application.ApplicationContext;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import com.suncode.pwfl.workflow.form.component.annotation.ComponentsFormScript;
import com.suncode.pwfl.workflow.form.exception.AcceptanceException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

@Application
@ComponentsFormScript(value="scripts/dynamic-form-pwe/print-document-app-form.js")
public class PrintDocument {
    private static final Logger log = LoggerFactory.getLogger(PrintDocument.class);
    private static final String ID = "tools.application.printDocument";
    @Autowired
    private FileService fileService;
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentClassService documentClassService;
    private PrintService printService;

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id(ID)).name(ID.concat(".name"))).description(ID.concat(".desc"))).category(new Category[]{Categories.TOOLS})).icon((Icon)DivanteIcon.PRINTER2)).parameter().id("printerName").name(ID.concat(".param.printerName.name")).description(ID.concat(".param.printerName.desc")).type((Type)Types.STRING).create()).parameter().id("fileSource").name(ID.concat(".param.fileSource.name")).description(ID.concat(".param.fileSource.desc")).type((Type)Types.STRING).create()).parameter().id("fileId").name(ID.concat(".param.fileId.name")).description(ID.concat(".param.fileId.desc")).type((Type)Types.INTEGER).optional().create()).parameter().id("documentId").name(ID.concat(".param.documentId.name")).description(ID.concat(".param.documentId.desc")).type((Type)Types.INTEGER).optional().create()).parameter().id("documentClassDocumentId").name(ID.concat(".param.documentClassDocumentId.name")).description(ID.concat(".param.documentClassDocumentId.desc")).type((Type)Types.STRING).optional().create()).parameter().id("documentClass").name(ID.concat(".param.documentClass.name")).description(ID.concat(".param.documentClass.desc")).type((Type)Types.STRING).optional().create();
    }

    public void execute(@Param String printerName, @Param String fileSource, @Param Integer fileId, @Param Integer documentId, @Param String documentClassDocumentId, @Param String documentClass, ApplicationContext context) throws AcceptanceException {
        try {
            Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)printerName), (String)"printerName cannot be empty, null or whitespace only");
            this.printService = this.findPrinter(printerName);
            WfFile file = this.resolveTargetFile(fileSource, fileId, documentId, documentClassDocumentId, documentClass, context);
            this.validateFileType(file.getFileName());
            this.printFile(file);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new AcceptanceException((Throwable)e);
        }
    }

    private WfFile resolveTargetFile(String fileSource, Integer fileId, Integer documentId, String documentClassDocumentId, String documentClass, ApplicationContext context) {
        List activityDocuments = this.documentFinder.getDocumentsFromActivity(context.getProcessId(), context.getActivityId(), new String[]{"documentClass"});
        switch (fileSource) {
            case "FILEID": {
                return this.getFileByFileId(activityDocuments, fileId.intValue());
            }
            case "DOCUMENTID": {
                return this.getFileByDocumentId(activityDocuments, documentClassDocumentId, documentId.intValue());
            }
            case "DOCUMENTCLASS": {
                return this.getFileByDocumentClass(activityDocuments, documentClass);
            }
        }
        throw new IllegalArgumentException("Parameter fileSource is invalid: " + fileSource);
    }

    private WfFile getFileByFileId(List<WfDocument> activityDocuments, long fileId) {
        return activityDocuments.stream().filter(document -> document.getFile().getId() == fileId).findFirst().map(WfDocument::getFile).orElseThrow(() -> new NoSuchElementException("No file found in process for fileId: " + fileId));
    }

    private WfFile getFileByDocumentId(List<WfDocument> activityDocuments, String documentClassName, long documentId) {
        long documentClassId = this.getDocumentClassId(documentClassName);
        return activityDocuments.stream().filter(document -> document.getDocumentClassId() == documentClassId && document.getId() == documentId).findFirst().map(WfDocument::getFile).orElseThrow(() -> new NoSuchElementException("No file found in process for documentId: " + documentId + " and documentClass: " + documentClassName));
    }

    private WfFile getFileByDocumentClass(List<WfDocument> activityDocuments, String documentClassName) {
        long documentClassId = this.getDocumentClassId(documentClassName);
        List<WfDocument> foundDocuments = activityDocuments.stream().filter(document -> document.getDocumentClassId() == documentClassId).toList();
        if (foundDocuments.size() != 1) {
            throw new IllegalStateException("Expected exactly one document of class: " + documentClassName + " attached to process, but found " + foundDocuments.size());
        }
        return foundDocuments.get(0).getFile();
    }

    private long getDocumentClassId(String documentClassName) {
        return this.documentClassService.getDocumentClass(documentClassName, new String[0]).getId();
    }

    private void validateFileType(String fileName) {
        String extension = this.getFileExtension(fileName).toUpperCase();
        try {
            SupportedFileExtension.valueOf(extension);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unsupported file format: " + extension);
        }
    }

    private PrintService findPrinter(String printerName) {
        return Arrays.stream(PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, null)).filter(service -> service.getName().equalsIgnoreCase(printerName)).findFirst().orElseThrow(() -> new PrinterNotFoundException("Printer not found with name: " + printerName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void printFile(WfFile file) throws IOException, PrinterException {
        Path tempFile = null;
        try {
            switch (SupportedFileExtension.valueOf(this.getFileExtension(file.getFileName()).toUpperCase())) {
                case DOCX: {
                    File pdf = this.convertWordToPdf(file);
                    tempFile = pdf.toPath();
                    this.printPdf(tempFile, file.getFileName());
                    break;
                }
                case PDF: {
                    tempFile = this.writeArchiveFileToTemp(file);
                    this.printPdf(tempFile, file.getFileName());
                    break;
                }
                case PNG: 
                case JPG: 
                case JPEG: {
                    tempFile = this.writeArchiveFileToTemp(file);
                    this.printImage(tempFile, file.getFileName());
                    break;
                }
                case TXT: {
                    tempFile = this.writeArchiveFileToTemp(file);
                    this.printText(tempFile, file.getFileName());
                }
            }
            if (tempFile == null) return;
        }
        catch (Throwable throwable) {
            if (tempFile == null) throw throwable;
            Files.deleteIfExists(tempFile);
            throw throwable;
        }
        Files.deleteIfExists(tempFile);
    }

    private void printPdf(Path pdfPath, String jobName) throws IOException, PrinterException {
        try (PDDocument document = PDDocument.load((File)pdfPath.toFile());){
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintService(this.printService);
            job.setJobName(jobName);
            PDFPrintable printable = new PDFPrintable(document, Scaling.SHRINK_TO_FIT);
            Book book = new Book();
            PageFormat pageFormat = job.defaultPage();
            book.append((Printable)printable, pageFormat, document.getNumberOfPages());
            job.setPageable(book);
            job.print();
        }
    }

    private void printImage(Path imagePath, String jobName) throws IOException, PrinterException {
        BufferedImage image = ImageIO.read(imagePath.toFile());
        if (image == null) {
            throw new IOException("Could not read image file: " + String.valueOf(imagePath));
        }
        Printable printable = (graphics, pageFormat, pageIndex) -> {
            if (pageIndex > 0) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double imageWidth = image.getWidth();
            double imageHeight = image.getHeight();
            double imageableWidth = pageFormat.getImageableWidth();
            double imageableHeight = pageFormat.getImageableHeight();
            double scale = Math.min(imageableWidth / imageWidth, imageableHeight / imageHeight);
            int roundedWidth = (int)Math.round(imageWidth * scale);
            int roundedHeight = (int)Math.round(imageHeight * scale);
            graphics2D.drawImage(image, 0, 0, roundedWidth, roundedHeight, null);
            return 0;
        };
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintService(this.printService);
        job.setJobName(jobName);
        job.setPrintable(printable);
        job.print();
    }

    private void printText(Path textPath, String jobName) throws IOException, PrinterException {
        List<String> lines = Files.readAllLines(textPath, StandardCharsets.UTF_8);
        Printable printable = (graphics, pageFormat, pageIndex) -> {
            Graphics2D graphics2D = (Graphics2D)graphics;
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int lineHeight = fontMetrics.getHeight();
            int linesPerPage = Math.max(1, (int)(pageFormat.getImageableHeight() / (double)lineHeight));
            int start = pageIndex * linesPerPage;
            if (start >= lines.size()) {
                return 1;
            }
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            int ascent = fontMetrics.getAscent();
            for (int i = start; i < Math.min(start + linesPerPage, lines.size()); ++i) {
                graphics2D.drawString((String)lines.get(i), 0, ascent);
                ascent += lineHeight;
            }
            return 0;
        };
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintService(this.printService);
        job.setJobName(jobName);
        job.setPrintable(printable);
        job.print();
    }

    private Path writeArchiveFileToTemp(WfFile file) throws IOException {
        String workingDirectory = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
        Path tempFile = Files.createTempFile(Path.of(workingDirectory, new String[0]), "print_", "." + this.getFileExtension(file.getFileName()), new FileAttribute[0]);
        try (InputStream is = this.fileService.getFileInputStream(Long.valueOf(file.getId()));){
            Files.copy(is, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return tempFile;
    }

    private File convertWordToPdf(WfFile file) throws IOException {
        String workingDirectory = SystemProperties.getString((DefinedSystemParameter)DefinedSystemParameter.WORKING_DIRECTORY);
        String baseName = FilenameUtils.removeExtension((String)file.getFileName());
        String pdfPath = workingDirectory + File.separator + "print_" + baseName + "_" + System.currentTimeMillis() + ".pdf";
        File pdf = PrepeareDoc.doc2PdfWithoutOO((WfFile)file, (String)pdfPath);
        Assert.notNull((Object)pdf, (String)"Cannot convert Word document to PDF");
        return pdf;
    }

    private String getFileExtension(String fileName) {
        return FilenameUtils.getExtension((String)fileName);
    }
}

