PWE.integrationComponent.registerFormAction('tools.document-info-versions', {
	apiVersion: 2,
	buildForm: function (form, options) {
		if (options.destination == "FORM" || options.destination == "BUTTON") {
			form.addLabel(TOOLS.t("tools.inputparam.label"))
			form.addCombobox({
				id: "document-class-names",
				notEmpty: true,
				remote: {
					url: "plugin/com.suncode.plugin-tools/docs/docClassList",
					fields: [{
						name: "docClassName",
						type: "string"
					}, {
						name: "docClassDesc",
						type: "string"
					}

					]
				},
				valueField: "docClassName",
				displayField: "docClassName",
				sort: [{
					property: "docClassName",
					direction: "ASC"
				}]
			});
			let docClassNames = form.getValue("document-class-names");
			if (docClassNames == null || docClassNames.length === 0) {
				form.addField({id: "document-class-name", hidden: true});
				let oldClassName = form.getValue("document-class-name");
				if (oldClassName) {
					form.addFieldToArray("document-class-names");
					form.setFieldValueInArray("document-class-names", 0, oldClassName);
				}
			}
		} else if (options.destination == "VARIABLE") {
			// document class id bierze z pola
		} else if (options.destination == "VARIABLESET") {
			form.addLabel(TOOLS.t("tools.inputparam.label"))
			form.addField({
				id: "document-class-name-array",
				notEmpty: true
			});
		} else {
			alert("Destination: " + options.destination + " not supported");
			return;
		}
		form.addLabel(TOOLS.t("tools.outputparam.label"))
		form.addField({
			id: "table-id",
			notEmpty: true
		});
		form.addField("fileName");
		form.addField("fileId");
		form.addField("docId");
		form.addField("uploader");
		form.addField("fileDate");
		form.addField("fileDateTime");
		form.addField("version");
		form.addField("comment");
		form.addField("documentClassName");
		form.addCombobox({
			id: "wayOfAdding",
			values: [
				{ id: "OVERWRITE_ALL_COLUMNS", display: TOOLS.t("tools.wayOfAdding.overwrite_all_columns") },
				{ id: "OVERWRITE_UPDATED_COLUMNS", display: TOOLS.t("tools.wayOfAdding.overwrite_updated_column") },
				{ id: "ADD", display: TOOLS.t("tools.wayOfAdding.add") }
			],
			listeners: {
				change: function (value) {
					if (value.indexOf("OVERWRITE_UPDATED_COLUMNS") > -1) {
						form.show("rowSynch");
						if (form.getValue("rowSynch")) {
							form.setNotEmpty("fileId", true)
						}
					} else {
						form.hide("rowSynch");
						form.setNotEmpty("fileId", false)
					}
				}
			}
		});
		form.addField({
			id: "rowSynch",
			hidden: true,
			listeners: {
				change: function (value) {
					if (value) {
						form.setNotEmpty("fileId", true)
					} else {
						form.setNotEmpty("fileId", false)
					}
				}
			}
		});
		if (form.getValue("wayOfAdding") == "UNSET") {
			form.setValue("wayOfAdding", "OVERWRITE_ALL_COLUMNS");
		}
		if (form.getValue("wayOfAdding") == "OVERWRITE_UPDATED_COLUMNS") {
			form.show("rowSynch");
			if (form.getValue("rowSynch")) {
				form.setNotEmpty("fileId", true)
			}

		}
	}
});