PWE.integrationComponent.registerFormAction("hyperlink-column", {
    apiVersion: 2,
    buildForm: function (form) {
        form.addField("column-id");
        form.addField("href-link");
        form.addField("href-name");

        if (!(form.getValue("href-link") && form.getValue("href-link").length)) {
            form.hide("href-link");
            form.hide("href-name");
            form.addField("href-link-function");
            form.addField("href-name-function");
            form.addCombobox({
                id: "href-target",
                value: "_blank",
                valueField: "id",
                displayField:"display",
                values: [
                    {id: "_blank", display: TOOLS.t("hyperlink.target.self.name")},
                    {id: "_self", display: TOOLS.t("hyperlink.target.blank.name")}
                ]
            });

            const multiColumnFieldSet = form.addFieldSet({
                id: "hyperlink-multi-column-fieldset",
                title: TOOLS.t("hyperlink-multi-column-fieldset.title"),
                collapsible: false
            });

            const table = multiColumnFieldSet.addTable("multi-column-table");
            table.addField("column-id-array");
            table.addField("href-link-function-array");
            table.addField("href-name-function-array");

            table.addCombobox({
                id: "href-target-array",
                value: "_blank",
                valueField: "id",
                displayField:"display",
                values: [
                    {id: "_blank", display: TOOLS.t("hyperlink.target.self.name")},
                    {id: "_self", display: TOOLS.t("hyperlink.target.blank.name")}
                ]
            });

            if (!form.getValue("href-link-function") && !form.getValue("href-name-function")) {
                form.hide("column-id");
                form.hide("href-link-function");
                form.hide("href-name-function");
                form.hide("href-target");
            }
        }
    },
    validateForm: function (form) {
        let isValid = true;

        if (!form.getValue("column-id") && !(form.getValue("column-id-array") && form.getValue("column-id-array").length)) {
            form.markError("column-id");
            form.markError("column-id-array");
            isValid = false;
        }

        if (!(form.getValue("href-link") && form.getValue("href-link").length)) {
            if (!form.getValue("href-link-function") && !(form.getValue("href-link-function-array") && form.getValue("href-link-function-array").length)) {
                form.markError("href-link-function");
                form.markError("href-link-function-array");
                isValid = false;
            }

            if (!form.getValue("href-name-function") && !(form.getValue("href-name-function-array") && form.getValue("href-name-function-array").length)) {
                form.markError("href-name-function");
                form.markError("href-name-function-array");
                isValid = false;
            }
        }

        if (!isValid) {
            form.showErrorMessage(TOOLS.t("hyperlink-fill-in-required-fields.error"));
        }

        return isValid;
    }
});