PW.FormActions.create('tools-hide-table-on-selected-row', {
    variableSetInit: function (variableSet) {
        this.conditions = this.get("condition");
        this.tableIds = this.get("tableIds")
        if (this.tableIds.length !== this.conditions.length) {
            Logger.error('Parameters must have the same length');
            return;
        }
        for (let i = 0, len = this.conditions.length; i < len; i++) {
            if (!this.conditions[i] || this.conditions[i].getReturnType() !== PW.BooleanType) {
                Logger.error('Function Error nr ' + i);
                Logger.error('Action hide-table-on-selected needs boolean function in condition parameter.');
                return;
            }
        }
        variableSet.on('select', this.fnSelected, this);
    },

    enable: function () {
        this.enabled = true;
    },

    disable: function () {
        this.enabled = false;
    },

    fnSelected: function (variableSet, selected) {
        if (!this.enabled) {
            return;
        }
        this.setContextVariable("currentRow", selected[0].index);
        for (let i = 0, len = this.conditions.length; i < len; i++) {
            if (this.conditions[i].call()) {
                VariableSetService.hide(this.tableIds[i]);
            } else {
                VariableSetService.show(this.tableIds[i]);
            }
        }
    },
});