PW.FormActions.create('tools.confirm-msg', {

	init: function() {
		this.windowShown = false;
	},

	defaultActions: {
		button : function(button) {
			if (button.isAcceptanceButton()) {
				if (!this.windowShown) {
					this.confirmWindowMessage(button);
					return false;
				}
			} else {
				this.confirmWindowMessage();
			}
		},
		variable: function() {
			this.confirmWindowMessage();
		},
	},

	confirmWindowMessage: function(button) {
		let me = this;
		let title = this.get("msg-title");
		let variableId = this.get("veriable-to-set").getId();
		let message = this.get("msg-txt");
		let positiveAnswer = this.get("postive-answer");
		let negativeAnswer = this.get("negative-answer");

		MessageService.showConfirm({
			title : title,
			message : message,
			yes : function() {
				me.setVariableValue(variableId, positiveAnswer);
				if (button) {
					me.acceptForm(button);
				}
			},
			no : function() {
				me.setVariableValue(variableId, negativeAnswer);
				if (button) {
					me.acceptForm(button);
				}
			}
		});
	},

	setVariableValue: function(variableId, value) {
		VariableService.setValue(variableId, value);
		this.windowShown = true;
	},

	acceptForm: function(button) {
		FormService.accept({
			actionName: button.getId()
		});
	}
});