PW.FormActions.create('remove-button-from-table', {

    variableSetInit: function (variableSet) {
        this.table = VariableSetService.get(variableSet.getId());
    },

    enable: function () {
        if (this.get("remove-add-button")) {
            VariableSetService.hideBottomToolbarButton(this.table, "add");
        }
        if (this.get("remove-insert-button")) {
            VariableSetService.hideBottomToolbarButton(this.table, "insert");
        }
        if (this.get("remove-delete-button")) {
            VariableSetService.hideBottomToolbarButton(this.table, "delete");
        }
        if (this.get("remove-copy-button")) {
            VariableSetService.hideBottomToolbarButton(this.table, "copy");
        }
        let idButtons = this.get("remove-custom-button").filter(item => item !== "");
        let me = this;
        PW.each(idButtons, function (data) {
            VariableSetService.hideBottomToolbarButton(me.table, data);
        })
    },

    disable: function () {
        if (this.get("remove-add-button")) {
            VariableSetService.showBottomToolbarButton(this.table, "add");
        }
        if (this.get("remove-insert-button")) {
            VariableSetService.showBottomToolbarButton(this.table, "insert");
        }
        if (this.get("remove-delete-button")) {
            VariableSetService.showBottomToolbarButton(this.table, "delete");
        }
        if (this.get("remove-copy-button")) {
            VariableSetService.showBottomToolbarButton(this.table, "copy");
        }
        let idButtons = this.get("remove-custom-button").filter(item => item !== "");
        let me = this;
        PW.each(idButtons, function (data) {
            VariableSetService.showBottomToolbarButton(me.table, data);
        })
    }
});