/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.servlet;

import com.suncode.pwfl.administration.structure.OrganizationalUnit;
import com.suncode.pwfl.administration.structure.OrganizationalUnitFinder;
import com.suncode.pwfl.util.FinderFactory;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class InitVariableJOController {
    public static Logger log = Logger.getLogger(InitVariableJOController.class);

    @RequestMapping(value={"/init/jo"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> initJO() {
        log.debug((Object)"Pobieranie jednostek organizacyjnych");
        OrganizationalUnitFinder organizationUnitFinder = FinderFactory.getOrganizationalUnitFinder();
        List listOrganizationUnit = organizationUnitFinder.getAll(new String[0]);
        log.debug((Object)("Pobrano " + listOrganizationUnit.size() + " w tym "));
        Collections.sort(listOrganizationUnit, new Comparator<OrganizationalUnit>(){

            @Override
            public int compare(OrganizationalUnit ou1, OrganizationalUnit ou2) {
                return ou1.getName().compareTo(ou2.getName());
            }
        });
        StringBuilder sbName = new StringBuilder();
        StringBuilder sbSymbol = new StringBuilder();
        Boolean firstLoop = true;
        for (OrganizationalUnit ou : listOrganizationUnit) {
            if (!firstLoop.booleanValue()) {
                sbName.append(",");
                sbSymbol.append(",");
            }
            sbName.append(ou.getName());
            sbSymbol.append(ou.getSymbol());
            firstLoop = false;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", this.encode(sbName.toString()));
        result.put("symbol", this.encode(sbSymbol.toString()));
        log.debug((Object)("Jednostki organizacyjne ('Nazwy'): " + sbName.toString()));
        log.debug((Object)("Jednostki organizacyjne ('Symbol'): " + sbSymbol.toString()));
        return result;
    }

    private String encode(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, StandardCharsets.UTF_8.toString()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            log.debug((Object)"B\u0142\u0105d w kodowaniu");
            e.printStackTrace();
            return toEncode;
        }
    }
}

