/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.servlet;

import com.plusmpm.i18n.I18NCustom;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.tools.common.DocumentClassPojo;
import com.suncode.plugin.tools.savefile.dto.DocumentClassIndexDto;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.search.CountedResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/docs"})
public class DocumentsController {
    @Autowired
    private DocumentClassService docClassService;
    @Autowired
    private DocumentFinder documentFinder;

    @RequestMapping(value={"classNames"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getDocClassNames() {
        List<DocumentClass> classes = this.getAllDocClasses();
        ArrayList<String> classNames = new ArrayList<String>();
        for (DocumentClass docClass : classes) {
            classNames.add(docClass.getName());
        }
        return classNames;
    }

    @RequestMapping(value={"classIds"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Long> getDocClassIds() {
        List<DocumentClass> classes = this.getAllDocClasses();
        ArrayList<Long> classIds = new ArrayList<Long>();
        for (DocumentClass docClass : classes) {
            classIds.add(docClass.getId());
        }
        return classIds;
    }

    @RequestMapping(value={"classIdsAndNames"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<Long, String> getDocClassIdsAndNames() {
        List<DocumentClass> classes = this.getAllDocClasses();
        HashMap<Long, String> classIdsAndNames = new HashMap<Long, String>();
        for (DocumentClass docClass : classes) {
            classIdsAndNames.put(docClass.getId(), docClass.getName());
        }
        return classIdsAndNames;
    }

    @RequestMapping(value={"classIndexesIdsAndNames/{classId}"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<Long, String> getDocClassIndexesIdsAndNames(@PathVariable(value="classId") Long classId) {
        DocumentClass temp = (DocumentClass)this.docClassService.get((Serializable)classId, new String[]{"indexes"});
        Set indexes = temp.getIndexes();
        HashMap<Long, String> classIndexesIdsAndNames = new HashMap<Long, String>();
        for (DocumentClassIndex docClassIndexes : indexes) {
            classIndexesIdsAndNames.put(docClassIndexes.getId(), docClassIndexes.getName());
        }
        return classIndexesIdsAndNames;
    }

    @RequestMapping(value={"classSourceNames"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getClassSourceNames() {
        DocumentEventTypes[] enums;
        ArrayList<String> result = new ArrayList<String>();
        for (DocumentEventTypes documentEventTypes : enums = DocumentEventTypes.values()) {
            result.add(documentEventTypes.name());
        }
        return result;
    }

    @RequestMapping(value={"docClassList"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getDocumentClassList(@RequestParam String query, @RequestParam String start, @RequestParam String limit) {
        CountedResult result = new CountedResult();
        List<DocumentClass> classes = this.getAllDocClasses();
        ArrayList<Map> docClassInfoList = new ArrayList<Map>();
        ArrayList tempList = new ArrayList();
        for (DocumentClass documentClass : classes) {
            HashMap<String, String> docClassInfo = new HashMap<String, String>();
            docClassInfo.put("docClassId", documentClass.getId().toString());
            docClassInfo.put("docClassName", documentClass.getName());
            docClassInfo.put("docClassDesc", documentClass.getDescription());
            tempList.add(docClassInfo);
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            docClassInfoList = tempList;
        } else {
            for (Map map : tempList) {
                if (!((String)map.get("docClassName")).toLowerCase().contains(query.toLowerCase()) && !((String)map.get("docClassId")).toLowerCase().contains(query.toLowerCase())) continue;
                docClassInfoList.add(map);
            }
        }
        int totalResult = docClassInfoList.size();
        Long l = Long.valueOf(start);
        Long limitL = Long.valueOf(limit);
        if (totalResult > limitL.intValue()) {
            result.setData(docClassInfoList.subList(l.intValue(), l.intValue() + limitL.intValue() - 1));
        } else {
            result.setData(docClassInfoList);
        }
        result.setTotal((long)totalResult);
        return result;
    }

    @RequestMapping(value={"info/class"}, method={RequestMethod.POST})
    @ResponseBody
    public CountedResult<DocumentClassPojo> getClassNameAndID(@RequestParam(value="processId") String processId, @RequestParam(value="activityId") String activityId) {
        List activityDocuments = this.documentFinder.getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"});
        CountedResult result = new CountedResult();
        if (!activityDocuments.isEmpty()) {
            Map<Long, String> classNameIdAll = this.getDocClassIdsAndNames();
            I18NCustom i18nCustom = new I18NCustom();
            List data = activityDocuments.stream().filter(doc -> classNameIdAll.containsKey(doc.getDocumentClassId())).map(doc -> new DocumentClassPojo(doc.getDocumentClassId(), i18nCustom.getString((String)classNameIdAll.get(doc.getDocumentClassId())))).distinct().sorted(Comparator.comparing(DocumentClassPojo::getName)).collect(Collectors.toList());
            result.setData(data);
            result.setTotal((long)data.size());
        }
        return result;
    }

    @RequestMapping(value={"documentClassIndexList/{documentClassName}"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<DocumentClassIndexDto> getDocumentClassIndexList(@PathVariable(value="documentClassName") String docClassName, @RequestParam String query, @RequestParam Integer start, @RequestParam Integer limit) {
        DocumentClass documentClass = this.docClassService.getDocumentClass(docClassName, new String[]{"indexes"});
        try {
            if (documentClass == null) {
                documentClass = (DocumentClass)this.docClassService.get((Serializable)Long.valueOf(Long.parseLong(docClassName)), new String[]{"indexes"});
            }
        }
        catch (Exception e) {
            ArrayList<DocumentClassIndexDto> dataError = new ArrayList<DocumentClassIndexDto>();
            DocumentClassIndexDto documentClassIndex = DocumentClassIndexDto.builder().name("").description(e.getMessage()).type("Server error").build();
            dataError.add(documentClassIndex);
            return new CountedResult((long)dataError.size(), dataError);
        }
        Set indexes = documentClass.getIndexes();
        ArrayList<DocumentClassIndexDto> tempDocumentClassIndexes = new ArrayList<DocumentClassIndexDto>();
        for (DocumentClassIndex documentClassIndex : indexes) {
            DocumentClassIndexDto documentClassIndexDto = DocumentClassIndexDto.builder().id(documentClassIndex.getId()).name(documentClassIndex.getName()).description(documentClassIndex.getDescription()).type(documentClassIndex.getType().toString()).build();
            tempDocumentClassIndexes.add(documentClassIndexDto);
        }
        List resultList = tempDocumentClassIndexes.stream().filter(index -> index.getName().toLowerCase().contains(query.toLowerCase()) || index.getId().toString().toLowerCase().contains(query.toLowerCase())).collect(Collectors.toList());
        resultList = resultList.size() > limit ? resultList.subList(start, start + limit - 1) : resultList;
        return new CountedResult((long)resultList.size(), resultList);
    }

    private List<DocumentClass> getAllDocClasses() {
        return this.docClassService.getAll(new String[0]);
    }
}

