/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.servlet;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/docs/version"})
public class DocumentVersionController {
    @Autowired
    private DocumentFinder documentFinder;
    @Autowired
    private DocumentClassService docClassService;

    @RequestMapping(value={"{classId}/{docId}/info"}, method={RequestMethod.GET})
    @ResponseBody
    public CountedResult<Map<String, String>> getInfoVersionsFromCurrentDoc(@PathVariable(value="classId") Long docClassId, @PathVariable(value="docId") Long docId) {
        CountedResult cResult = new CountedResult();
        List<Map<String, String>> data = this.readInfoFromDocClass(docClassId, docId);
        cResult.setData(data);
        cResult.setTotal((long)data.size());
        return cResult;
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.POST})
    @ResponseBody
    public CountedResult<Map<String, String>> getInfoVersionFormProcessDoc(@RequestParam(value="documentclassnames") String[] docClassNames, @RequestParam(value="processid") String processId, @RequestParam(value="activityid") String activityId) {
        CountedResult cResult = new CountedResult();
        ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        List activityDocuments = this.documentFinder.getDocumentsFromActivity(processId, activityId, new String[]{"documentClass"});
        Set docClassIds = Arrays.stream(docClassNames).mapToLong(this::getDocumentClassId).boxed().collect(Collectors.toSet());
        for (WfDocument wfDocument : activityDocuments) {
            if (!docClassIds.contains(wfDocument.getDocumentClassId())) continue;
            data.addAll(this.readInfoFromDocClass(wfDocument.getDocumentClassId(), wfDocument.getId()));
        }
        cResult.setData(data);
        cResult.setTotal((long)data.size());
        return cResult;
    }

    private Long getDocumentClassId(String docClassName) {
        DocumentClass docClass = this.docClassService.getDocumentClass(docClassName, new String[0]);
        return docClass != null ? docClass.getId() : Long.parseLong(docClassName);
    }

    private List<Map<String, String>> readInfoFromDocClass(final Long documentClassId, final Long documentId) {
        final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        final SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        final ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
        PlatformTransactionManager hibernateTransactionManager = TransactionManagerFactory.getHibernateTransactionManager();
        TransactionTemplate template = new TransactionTemplate(hibernateTransactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                WfDocument currentDocument = DocumentVersionController.this.documentFinder.getDocument(documentId, documentClassId);
                if (currentDocument != null) {
                    WfFile wfFile = currentDocument.getVersion().getNewestFile();
                    HashMap<String, String> oneInfoVersion = null;
                    while (wfFile != null) {
                        oneInfoVersion = new HashMap<String, String>();
                        oneInfoVersion.put("docId", Long.toString(currentDocument.getId()));
                        oneInfoVersion.put("version", Long.toString(wfFile.getVersion().getVersion()));
                        oneInfoVersion.put("uploader", wfFile.getUploader());
                        oneInfoVersion.put("comment", wfFile.getVersion().getComment());
                        oneInfoVersion.put("fileDate", dateFormatter.format(wfFile.getFileDate()));
                        oneInfoVersion.put("fileDateTime", dateTimeFormatter.format(wfFile.getFileDate()));
                        oneInfoVersion.put("fileName", wfFile.getFileName());
                        oneInfoVersion.put("fileId", Long.toString(wfFile.getId()));
                        oneInfoVersion.put("documentClassName", wfFile.getDocumentClass().getName());
                        data.add(oneInfoVersion);
                        wfFile = wfFile.getVersion().getParentFile();
                    }
                }
            }
        });
        return data;
    }
}

