/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.service;

import com.suncode.plugin.tools.service.DeletingFileService;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeletingFileServiceImpl
implements DeletingFileService {
    private static final Logger log = LoggerFactory.getLogger(DeletingFileServiceImpl.class);

    @Override
    public void deleteFiles(String directory, String filename, boolean searchInSubdirectories, String errorMessage) throws IOException {
        Pattern pattern;
        AtomicInteger allFilesCounter = new AtomicInteger(0);
        Path root = new File(directory).toPath();
        long deletedFilesCounter = this.process(root, pattern = Pattern.compile(filename), searchInSubdirectories, -1, allFilesCounter);
        if (deletedFilesCounter < (long)allFilesCounter.get()) {
            String result = (long)allFilesCounter.get() - deletedFilesCounter + " / " + allFilesCounter.get();
            log.warn(result + " " + errorMessage);
        }
    }

    @Override
    public long deleteFiles(String path, int fileAgeInDays, boolean searchInSubdirectories) throws IOException {
        Path root = new File(path).toPath();
        Pattern pattern = Pattern.compile(".+");
        return this.process(root, pattern, searchInSubdirectories, fileAgeInDays, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long process(Path root, Pattern regex, Boolean searchInSubdirectories, int maxFileAgeInDays, AtomicInteger allFilesCounter) throws IOException {
        long counter = 0L;
        Date currentDate = new Date();
        try (DirectoryStream<Path> directory = Files.newDirectoryStream(root);){
            for (Path path : directory) {
                if (Boolean.TRUE.equals(searchInSubdirectories) && Files.isDirectory(path, new LinkOption[0])) {
                    counter += this.process(path, regex, true, maxFileAgeInDays, allFilesCounter);
                }
                if (!regex.matcher(path.getFileName().toString()).matches()) continue;
                BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                boolean skipFile = this.checkFileAge(currentDate, attributes.creationTime(), maxFileAgeInDays);
                if (!Files.isRegularFile(path, new LinkOption[0]) && (!Files.isDirectory(path, new LinkOption[0]) || !this.isEmpty(path)) || skipFile) continue;
                try {
                    Files.delete(path);
                    ++counter;
                }
                catch (IOException e) {
                    log.error("Cannot delete file: " + String.valueOf(path));
                }
                finally {
                    if (allFilesCounter == null) continue;
                    allFilesCounter.getAndIncrement();
                }
            }
        }
        return counter;
    }

    private boolean isEmpty(Path path) throws IOException {
        try (DirectoryStream<Path> directory = Files.newDirectoryStream(path);){
            boolean bl = !directory.iterator().hasNext();
            return bl;
        }
    }

    private boolean checkFileAge(Date currentDate, FileTime creationTime, int maxFileAgeInDays) {
        if (maxFileAgeInDays >= 0 && creationTime != null) {
            Date creationDate = new Date(creationTime.to(TimeUnit.MILLISECONDS));
            return TimeUnit.DAYS.convert(Math.abs(creationDate.getTime() - currentDate.getTime()), TimeUnit.MILLISECONDS) < (long)maxFileAgeInDays;
        }
        return false;
    }
}

