/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.service;

import com.suncode.plugin.tools.service.CopyingFileService;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CopyingFileServiceImpl
implements CopyingFileService {
    private static final Logger log = LoggerFactory.getLogger(CopyingFileServiceImpl.class);

    @Override
    public boolean copyDocument(String source, String destination, boolean overwrite) {
        try {
            Files.createDirectories(Paths.get(destination, new String[0]).getParent(), new FileAttribute[0]);
            if (Boolean.TRUE.equals(overwrite)) {
                Files.copy(Paths.get(source, new String[0]), Paths.get(destination, new String[0]), StandardCopyOption.REPLACE_EXISTING);
            } else if (!Paths.get(destination, new String[0]).toFile().exists()) {
                Files.copy(Paths.get(source, new String[0]), Paths.get(destination, new String[0]), new CopyOption[0]);
            }
            return true;
        }
        catch (IOException e) {
            log.error("Error copying file: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

