/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.scheduledtask.filebackup;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.service.DeletingFileService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@ScheduledTask
public class DeleteFilesTask {
    private static final Logger log = LoggerFactory.getLogger(DeleteFilesTask.class);
    @Autowired
    private DeletingFileService deletingFileService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("tools.scheduledtask.filebackup.DeleteFilesTask")).name("tools.scheduledtask.filebackup.DeleteFilesTask.name")).description("tools.scheduledtask.filebackup.DeleteFilesTask.desc")).category(new Category[]{Categories.TOOLS})).parameter().id("sourcePath").name("tools.scheduledtask.filebackup.DeleteFilesTask.param.sourcePath.name").description("tools.scheduledtask.filebackup.DeleteFilesTask.param.sourcePath.desc").type((Type)Types.STRING).create()).parameter().id("fileAge").name("tools.scheduledtask.filebackup.DeleteFilesTask.param.fileAge.name").description("tools.scheduledtask.filebackup.DeleteFilesTask.param.fileAge.desc").type((Type)Types.INTEGER).create();
    }

    public void execute(@Param String sourcePath, @Param int fileAge, ScheduledTaskInstanceInfo taskInfo, org.apache.log4j.Logger logger) {
        logger.info((Object)("Starting task: " + taskInfo.getName()));
        try {
            long deletedFilesCounter = this.deletingFileService.deleteFiles(sourcePath, fileAge, true);
            logger.info((Object)(deletedFilesCounter + " files deleted!"));
        }
        catch (Exception e) {
            log.error("Error deleting file: " + e.getMessage(), (Throwable)e);
        }
        logger.info((Object)("Finished task: " + taskInfo.getName()));
    }
}

