/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.scheduledtask.db.service;

import com.suncode.plugin.tools.scheduledtask.db.dao.EncryptionDecryptionTaskLogDao;
import com.suncode.plugin.tools.scheduledtask.db.entity.EncryptionDecryptionTaskLog;
import com.suncode.plugin.tools.scheduledtask.db.service.EncryptionDecryptionTaskLogService;
import com.suncode.plugin.tools.scheduledtask.dto.WfFileDto;
import com.suncode.plugin.tools.scheduledtask.type.EncryptionDecryptionType;
import com.suncode.plugin.tools.scheduledtask.type.TaskStatus;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EncryptionDecryptionTaskLogServiceImpl
extends EditableServiceImpl<EncryptionDecryptionTaskLog, Long, EncryptionDecryptionTaskLogDao>
implements EncryptionDecryptionTaskLogService {
    @Autowired
    public void setDao(EncryptionDecryptionTaskLogDao dao) {
        this.dao = dao;
    }

    @Override
    public void saveLogEncryption(ScheduledTaskInstanceInfo scheduledTaskInfo, WfFileDto wfFile, TaskStatus taskStatus, String errorMessage) {
        EncryptionDecryptionType encryptionType = EncryptionDecryptionType.ENCRYPTION;
        ((EncryptionDecryptionTaskLogDao)this.dao).save(this.buildEntityLog(scheduledTaskInfo, wfFile, taskStatus, errorMessage, encryptionType));
    }

    @Override
    public void saveLogDecryption(ScheduledTaskInstanceInfo scheduledTaskInfo, WfFileDto wfFile, TaskStatus taskStatus, String errorMessage) {
        EncryptionDecryptionType decryptionType = EncryptionDecryptionType.DECRYPTION;
        ((EncryptionDecryptionTaskLogDao)this.dao).save(this.buildEntityLog(scheduledTaskInfo, wfFile, taskStatus, errorMessage, decryptionType));
    }

    private EncryptionDecryptionTaskLog buildEntityLog(ScheduledTaskInstanceInfo scheduledTaskInfo, WfFileDto wfFile, TaskStatus taskStatus, String errorMessage, EncryptionDecryptionType encryptionDecryptionType) {
        return EncryptionDecryptionTaskLog.builder().scheduledTaskId(scheduledTaskInfo.getId()).scheduledTaskName(scheduledTaskInfo.getName()).errorMessage(errorMessage).status(taskStatus.name()).operationType(encryptionDecryptionType.name()).fileId(wfFile != null ? Long.valueOf(wfFile.getId()) : null).timestamp(new Timestamp(DateTime.now().getMillis())).filename(wfFile != null ? wfFile.getFileName() : null).systemFilename(wfFile != null ? wfFile.getSystemFileName() : null).documentClassId(wfFile != null ? Long.valueOf(wfFile.getDocumentClassId()) : null).documentClassName(wfFile != null ? wfFile.getDocumentClassName() : null).build();
    }
}

