/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.scheduledtask;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.exception.CancelTaskException;
import com.suncode.plugin.tools.exception.TimeoutException;
import com.suncode.plugin.tools.exception.util.ExceptionUtils;
import com.suncode.plugin.tools.json.util.JsonConverter;
import com.suncode.plugin.tools.scheduledtask.db.service.EncryptionDecryptionTaskLogService;
import com.suncode.plugin.tools.scheduledtask.dto.WfFileDto;
import com.suncode.plugin.tools.scheduledtask.type.TaskStatus;
import com.suncode.plugin.tools.scheduledtask.util.EncryptionDecryptionTaskConfig;
import com.suncode.plugin.tools.scheduledtask.util.EncryptionDecryptionTaskStatistics;
import com.suncode.plugin.tools.scheduledtask.util.ExecuteDataSource;
import com.suncode.plugin.tools.scheduledtask.util.ScheduledTaskUtil;
import com.suncode.plugin.tools.scheduledtask.util.Validation;
import com.suncode.plugin.tools.service.DocumentArchiveService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.FileCipherService;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@ScheduledTask
public class ArchiveEncryptionTask {
    private static final Logger log = LoggerFactory.getLogger(ArchiveEncryptionTask.class);
    @Autowired
    private EncryptionDecryptionTaskLogService taskLogService;
    @Autowired
    private FileCipherService fileCipherService;
    @Autowired
    private DocumentClassService docClassService;
    @Autowired
    private DocumentArchiveService documentArchiveService;
    @Autowired
    private Validation validationParams;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("tools.archive-encryption-task")).name("tools.archive-encryption-task.name")).description("tools.archive-encryption-task.desc")).category(new Category[]{Categories.TOOLS})).cancelable().parameter().id("docClassName").name("tools.archive-encryption-task.docClassName.name").description("tools.archive-encryption-task.docClassName.desc").type((Type)Types.STRING).create()).parameter().id("fromFileCreationDate").name("tools.archive-encryption-task.fromFileCreationDate.name").description("tools.archive-encryption-task.fromFileCreationDate.desc").type((Type)Types.DATE).create()).parameter().id("toFileCreationDate").name("tools.archive-encryption-task.toFileCreationDate.name").description("tools.archive-encryption-task.toFileCreationDate.desc").type((Type)Types.DATE).create()).parameter().id("maximumRunningTime").name("tools.archive-encryption-task.maximumRunningTime.name").description("tools.archive-encryption-task.maximumRunningTime.desc").type((Type)Types.INTEGER).create()).parameter().id("nThreads").name("tools.archive-encryption-task.nThreads.name").description("tools.archive-encryption-task.nThreads.desc").type((Type)Types.INTEGER).create()).parameter().id("logInterval").name("tools.archive-encryption-task.logInterval.name").description("tools.archive-encryption-task.logInterval.desc").type((Type)Types.INTEGER).defaultValue((Object)1L).create()).parameter().id("disableScheduledTaskAfterFirstRun").name("tools.archive-encryption-task.disableScheduledTaskAfterFirstRun.name").description("tools.archive-encryption-task.disableScheduledTaskAfterFirstRun.desc").type((Type)Types.BOOLEAN).create()).parameter().id("jsonIndexMapping").name("tools.archive-encryption-task.jsonIndexMapping.name").description("tools.archive-encryption-task.jsonIndexMapping.desc").type((Type)Types.STRING).optional().create()).parameter().id("datasourceId").name("tools.archive-encryption-task.datasource-id.name").description("tools.archive-encryption-task.datasource-id.desc").type((Type)Types.STRING).optional().create()).parameter().id("datasourceParameters").name("tools.archive-encryption-task.datasource-parameters.name").description("tools.archive-encryption-task.datasource-parameters.desc").type((Type)Types.STRING).optional().create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(@Param String docClassName, @Param LocalDate fromFileCreationDate, @Param LocalDate toFileCreationDate, @Param Long maximumRunningTime, @Param Long nThreads, @Param Long logInterval, @Param boolean disableScheduledTaskAfterFirstRun, @Param String jsonIndexMapping, @Param String datasourceId, @Param String datasourceParameters, ScheduledTaskInstanceInfo scheduledTaskInfo, CancelationHandler cancelationHandler, org.apache.log4j.Logger taskLog) {
        taskLog.debug((Object)("Start task: " + scheduledTaskInfo.getName()));
        EncryptionDecryptionTaskStatistics statistic = new EncryptionDecryptionTaskStatistics(taskLog);
        try {
            Map<Object, Object> indexesToUpdate = StringUtils.isBlank((CharSequence)jsonIndexMapping) ? new HashMap() : JsonConverter.convertJsonToMap(jsonIndexMapping);
            this.validationParams.validNThreads(nThreads);
            ExecutorService executorService = Executors.newFixedThreadPool(nThreads.intValue());
            this.validationParams.validDateRange(fromFileCreationDate, toFileCreationDate);
            try {
                DocumentClass docClass = this.docClassService.getDocumentClass(docClassName.trim(), new String[0]);
                if (docClass == null) {
                    throw new IllegalArgumentException("Document class " + docClassName + "don't exist");
                }
                EncryptionDecryptionTaskConfig config = new EncryptionDecryptionTaskConfig(docClass, maximumRunningTime);
                this.validationParams.validDocumentClass(config);
                long lastFileId = 0L;
                int filePackageLimit = 1000;
                boolean filesToEncrypt = true;
                while (filesToEncrypt) {
                    filesToEncrypt = false;
                    List filesToEncrypted = this.documentArchiveService.findUnencryptedFiles(docClass.getId(), fromFileCreationDate.toDate(), toFileCreationDate.toDate(), lastFileId, filePackageLimit).stream().map(wfFile -> new WfFileDto((WfFile)wfFile)).sorted(Comparator.comparing(file -> file.getId())).collect(Collectors.toList());
                    statistic.setToProcessedFiles(filesToEncrypted.size());
                    taskLog.debug((Object)("Found :" + filesToEncrypted.size() + " files"));
                    filesToEncrypted.parallelStream().forEach(wfFile -> executorService.submit(() -> this.runThread(config, statistic, (WfFileDto)wfFile, cancelationHandler, scheduledTaskInfo, datasourceId, datasourceParameters, taskLog)));
                    lastFileId = ((WfFileDto)filesToEncrypted.get(filesToEncrypted.size() - 1)).getId();
                    if (filesToEncrypted.size() < 1000) continue;
                    filesToEncrypt = true;
                }
                executorService.shutdown();
                this.logProgression(cancelationHandler, executorService, statistic, logInterval);
                if (disableScheduledTaskAfterFirstRun) {
                    ScheduledTaskUtil.inactiveScheduledTask(scheduledTaskInfo.getId());
                }
            }
            finally {
                if (!executorService.isShutdown()) {
                    executorService.shutdownNow();
                }
            }
        }
        catch (CancelTaskException cTE) {
            taskLog.debug((Object)"Cancel By user");
            String string = "Cancel By user. " + statistic.summary();
            return string;
        }
        catch (Exception e) {
            taskLog.error((Object)"ERROR", (Throwable)e);
            throw e;
        }
        finally {
            taskLog.debug((Object)("All files to encrypted: " + statistic.getToProcessedFiles()));
            taskLog.debug((Object)("Error Files: " + statistic.getErrorFiles()));
            taskLog.debug((Object)("Success encrypted files: " + statistic.getSuccessProcessedFile()));
            taskLog.debug((Object)("Not processed:  " + statistic.getNotProcessedCount()));
            taskLog.debug((Object)("Data source errors: " + statistic.getDatasourceErrors()));
            taskLog.debug((Object)("End task: " + scheduledTaskInfo.getName()));
            if (statistic.isTimeout()) {
                taskLog.debug((Object)"Timeout");
                return "Timeout. " + statistic.summary();
            }
        }
        return statistic.summary();
    }

    private void logProgression(CancelationHandler cancelationHandler, ExecutorService executorService, EncryptionDecryptionTaskStatistics statistic, Long logInterval) {
        try {
            if (logInterval == null || logInterval == 0L) {
                logInterval = 1L;
            }
            Long notProcessedCount = statistic.getNotProcessedCount();
            Long interval = Math.abs(logInterval);
            Long intervalCounter = 0L;
            while (!executorService.isTerminated()) {
                ExceptionUtils.checkTaskCancellation(cancelationHandler);
                Thread.sleep(1000L);
                Long l = intervalCounter;
                intervalCounter = intervalCounter + 1L;
                if (intervalCounter != interval) continue;
                intervalCounter = 0L;
                if (notProcessedCount.longValue() == statistic.getNotProcessedCount()) continue;
                statistic.logDebug(statistic.summary());
                notProcessedCount = statistic.getNotProcessedCount();
            }
        }
        catch (InterruptedException e) {
            log.warn("Sleep: " + logInterval + "ms", (Throwable)e);
        }
    }

    private void runThread(EncryptionDecryptionTaskConfig config, EncryptionDecryptionTaskStatistics statistic, WfFileDto wfFile, CancelationHandler cancelationHandler, ScheduledTaskInstanceInfo scheduledTaskInfo, String datasourceId, String datasourceParameters, org.apache.log4j.Logger taskLog) {
        try {
            log.trace("Start Thread: " + Thread.currentThread().getName() + ". File encryption: " + wfFile.getFileName());
            ExceptionUtils.checkIsTimeout(config.getStartedDate(), config.getMaximumRunningTime().intValue());
            ExceptionUtils.checkTaskCancellation(cancelationHandler);
            this.encryptFile(statistic, wfFile, cancelationHandler);
            if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{datasourceId})) {
                try {
                    ExecuteDataSource.execute(datasourceId, datasourceParameters, wfFile, scheduledTaskInfo);
                }
                catch (Exception e) {
                    statistic.incErrorDatasource();
                    statistic.logError("Error while executing data source:" + datasourceId + " Params: " + datasourceParameters, e);
                }
            }
            this.taskLogService.saveLogEncryption(scheduledTaskInfo, wfFile, TaskStatus.SUCCESS, "");
        }
        catch (TimeoutException e) {
            statistic.setTimeout();
            log.trace("Timeout: " + Thread.currentThread().getName());
            this.taskLogService.saveLogEncryption(scheduledTaskInfo, wfFile, TaskStatus.TIMEOUT, e.getMessage());
            throw e;
        }
        catch (CancelTaskException cancelEx) {
            this.taskLogService.saveLogEncryption(scheduledTaskInfo, wfFile, TaskStatus.CANCEL, cancelEx.getMessage());
            throw cancelEx;
        }
        catch (Exception e) {
            this.taskLogService.saveLogEncryption(scheduledTaskInfo, wfFile, TaskStatus.ERROR, ExceptionUtils.getStackTrace(e, 4000));
            throw e;
        }
        finally {
            log.trace("Stop Thread: " + Thread.currentThread().getName() + ". File encryption: " + wfFile.getFileName());
        }
    }

    private void encryptFile(EncryptionDecryptionTaskStatistics statistic, WfFileDto wfFileDto, CancelationHandler cancelationHandler) {
        try {
            ExceptionUtils.checkTaskCancellation(cancelationHandler);
            this.fileCipherService.encryptFile(Long.valueOf(wfFileDto.getId()));
            statistic.incSuccessProcessedFile();
        }
        catch (Exception e) {
            statistic.incErrorFiles();
            statistic.logError(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }
}

