/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.scheduledtask;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.plugin.tools.exception.CancelTaskException;
import com.suncode.plugin.tools.exception.TimeoutException;
import com.suncode.plugin.tools.exception.util.ExceptionUtils;
import com.suncode.plugin.tools.scheduledtask.db.service.EncryptionDecryptionTaskLogService;
import com.suncode.plugin.tools.scheduledtask.dto.WfFileDto;
import com.suncode.plugin.tools.scheduledtask.type.TaskStatus;
import com.suncode.plugin.tools.scheduledtask.util.CompressionDecompressionTaskStatistics;
import com.suncode.plugin.tools.scheduledtask.util.ExecuteDataSource;
import com.suncode.plugin.tools.scheduledtask.util.ScheduledTaskUtil;
import com.suncode.plugin.tools.scheduledtask.util.Validation;
import com.suncode.plugin.tools.service.DocumentArchiveService;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskDefinitionBuilder;
import com.suncode.pwfl.administration.scheduledtask.ScheduledTaskInstanceInfo;
import com.suncode.pwfl.administration.scheduledtask.annotation.ScheduledTask;
import com.suncode.pwfl.administration.scheduledtask.context.CancelationHandler;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.archive.FileArchiver;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@ScheduledTask
public class ArchiveCompressionTask {
    private static final Logger log = LoggerFactory.getLogger(ArchiveCompressionTask.class);
    @Autowired
    private FileArchiver fileArchiver;
    @Autowired
    private DocumentArchiveService documentArchiveService;
    @Autowired
    private DocumentClassService docClassService;
    @Autowired
    private Validation validationParams;
    @Autowired
    private EncryptionDecryptionTaskLogService taskLogService;

    @Define
    public void definition(ScheduledTaskDefinitionBuilder builder) {
        ((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)((ScheduledTaskDefinitionBuilder)builder.id("tools.archive-compression-task")).name("tools.archive-compression-task.name")).description("tools.archive-compression-task.desc")).category(new Category[]{Categories.TOOLS})).cancelable().parameter().id("docClassName").name("tools.archive-compression-task.docClassName.name").description("tools.archive-compression-task.docClassName.desc").type((Type)Types.STRING).create()).parameter().id("fromFileCreationDate").name("tools.archive-compression-task.fromFileCreationDate.name").description("tools.archive-compression-task.fromFileCreationDate.desc").type((Type)Types.DATE).create()).parameter().id("toFileCreationDate").name("tools.archive-compression-task.toFileCreationDate.name").description("tools.archive-compression-task.toFileCreationDate.desc").type((Type)Types.DATE).create()).parameter().id("nThreads").name("tools.archive-compression-task.nThreads.name").description("tools.archive-compression-task.nThreads.desc").type((Type)Types.INTEGER).create()).parameter().id("logInterval").name("tools.archive-compression-task.logInterval.name").description("tools.archive-compression-task.logInterval.desc").type((Type)Types.INTEGER).defaultValue((Object)1L).create()).parameter().id("disableScheduledTaskAfterFirstRun").name("tools.archive-compression-task.disableScheduledTaskAfterFirstRun.name").description("tools.archive-compression-task.disableScheduledTaskAfterFirstRun.desc").type((Type)Types.BOOLEAN).create()).parameter().id("datasourceId").name("tools.archive-compression-task.datasource-id.name").description("tools.archive-compression-task.datasource-id.desc").type((Type)Types.STRING).optional().create()).parameter().id("datasourceParameters").name("tools.archive-compression-task.datasource-parameters.name").description("tools.archive-compression-task.datasource-parameters.desc").type((Type)Types.STRING).optional().create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(@Param String docClassName, @Param LocalDate fromFileCreationDate, @Param LocalDate toFileCreationDate, @Param Long nThreads, @Param Long logInterval, @Param boolean disableScheduledTaskAfterFirstRun, @Param String datasourceId, @Param String datasourceParameters, ScheduledTaskInstanceInfo scheduledTaskInfo, CancelationHandler cancelationHandler, org.apache.log4j.Logger taskLog) throws IOException {
        taskLog.debug((Object)("Start task: " + scheduledTaskInfo.getName()));
        CompressionDecompressionTaskStatistics statistic = new CompressionDecompressionTaskStatistics(taskLog);
        try {
            this.validationParams.validNThreads(nThreads);
            ExecutorService executorService = Executors.newFixedThreadPool(nThreads.intValue());
            this.validationParams.validDateRange(fromFileCreationDate, toFileCreationDate);
            try {
                DocumentClass docClass = this.docClassService.getDocumentClass(docClassName.trim(), new String[0]);
                if (docClass == null) {
                    throw new IllegalArgumentException("Document class " + docClassName + "don't exist");
                }
                Date startDate = fromFileCreationDate.toLocalDateTime(LocalTime.MIDNIGHT).minusMillis(1).toDate();
                Date endDate = toFileCreationDate.toLocalDateTime(LocalTime.MIDNIGHT).plusDays(1).toDate();
                List<WfFile> filesToCompress = this.documentArchiveService.findUncompressedFiles(docClass.getId(), startDate, endDate);
                taskLog.debug((Object)("Found :" + filesToCompress.size() + " files"));
                statistic.setToProcessedFiles(filesToCompress.size());
                filesToCompress.parallelStream().forEach(wfFile -> executorService.submit(() -> this.runThread(statistic, (WfFile)wfFile, cancelationHandler, scheduledTaskInfo, datasourceId, datasourceParameters)));
                executorService.shutdown();
                this.logProgression(cancelationHandler, executorService, statistic, logInterval);
                if (disableScheduledTaskAfterFirstRun) {
                    ScheduledTaskUtil.inactiveScheduledTask(scheduledTaskInfo.getId());
                }
            }
            finally {
                if (!executorService.isShutdown()) {
                    executorService.shutdownNow();
                }
            }
        }
        catch (CancelTaskException cTE) {
            taskLog.debug((Object)"Cancel By user");
            String string = "Cancel By user. " + statistic.summary();
            return string;
        }
        catch (Exception e) {
            taskLog.error((Object)"ERROR", (Throwable)e);
            throw e;
        }
        finally {
            taskLog.debug((Object)("All files to encrypted: " + statistic.getToProcessedFiles()));
            taskLog.debug((Object)("Error Files: " + statistic.getErrorFiles()));
            taskLog.debug((Object)("Success encrypted files: " + statistic.getSuccessProcessedFile()));
            taskLog.debug((Object)("Not processed:  " + statistic.getNotProcessedCount()));
            taskLog.debug((Object)("Data source errors: " + statistic.getDatasourceErrors()));
            taskLog.debug((Object)("End task: " + scheduledTaskInfo.getName()));
            if (statistic.isTimeout()) {
                taskLog.debug((Object)"Timeout");
                return "Timeout. " + statistic.summary();
            }
        }
        return statistic.summary();
    }

    private void logProgression(CancelationHandler cancelationHandler, ExecutorService executorService, CompressionDecompressionTaskStatistics statistic, Long logInterval) {
        try {
            if (logInterval == null || logInterval == 0L) {
                logInterval = 1L;
            }
            Long notProcessedCount = statistic.getNotProcessedCount();
            Long interval = Math.abs(logInterval);
            Long intervalCounter = 0L;
            while (!executorService.isTerminated()) {
                ExceptionUtils.checkTaskCancellation(cancelationHandler);
                Thread.sleep(1000L);
                Long l = intervalCounter;
                intervalCounter = intervalCounter + 1L;
                if (!intervalCounter.equals(interval)) continue;
                intervalCounter = 0L;
                if (notProcessedCount.longValue() == statistic.getNotProcessedCount()) continue;
                statistic.logDebug(statistic.summary());
                notProcessedCount = statistic.getNotProcessedCount();
            }
        }
        catch (InterruptedException e) {
            log.warn("Sleep: " + logInterval + "ms", (Throwable)e);
        }
    }

    private void runThread(CompressionDecompressionTaskStatistics statistic, WfFile wfFile, CancelationHandler cancelationHandler, ScheduledTaskInstanceInfo scheduledTaskInfo, String datasourceId, String datasourceParameters) {
        WfFileDto wfFileDto = WfFileDto.builder().id(wfFile.getId()).systemFileName(wfFile.getSystemFileName()).build();
        try {
            log.trace("Start Thread: " + Thread.currentThread().getName() + ". File to compress: " + wfFile.getFileName());
            ExceptionUtils.checkTaskCancellation(cancelationHandler);
            this.fileArchiver.compressFile(Long.valueOf(wfFile.getId()));
            statistic.incSuccessProcessedFile();
            if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{datasourceId})) {
                try {
                    ExecuteDataSource.execute(datasourceId, datasourceParameters, wfFileDto, scheduledTaskInfo);
                }
                catch (Exception e) {
                    statistic.incErrorDatasource();
                    statistic.logError("Error while executing data source:" + datasourceId + " Params: " + datasourceParameters, e);
                }
            }
            this.taskLogService.saveLogDecryption(scheduledTaskInfo, wfFileDto, TaskStatus.SUCCESS, "");
        }
        catch (TimeoutException e) {
            statistic.incErrorFiles();
            statistic.setTimeout();
            log.trace("Timeout: " + Thread.currentThread().getName());
            this.taskLogService.saveLogDecryption(scheduledTaskInfo, wfFileDto, TaskStatus.TIMEOUT, e.getMessage());
            throw e;
        }
        catch (CancelTaskException cancelEx) {
            this.taskLogService.saveLogDecryption(scheduledTaskInfo, wfFileDto, TaskStatus.CANCEL, cancelEx.getMessage());
            throw cancelEx;
        }
        catch (Exception e) {
            this.taskLogService.saveLogDecryption(scheduledTaskInfo, wfFileDto, TaskStatus.ERROR, ExceptionUtils.getStackTrace(e, 4000));
            throw e;
        }
        finally {
            log.trace("Stop Thread: " + Thread.currentThread().getName() + ". File to compress: " + wfFileDto.getFileName());
        }
    }
}

