/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.dbexplorer;

import com.suncode.dbexplorer.DatabaseExplorer;
import com.suncode.dbexplorer.alias.Alias;
import com.suncode.dbexplorer.database.Database;
import com.suncode.dbexplorer.database.DatabaseSession;
import com.suncode.pwfl.search.sql.SQLBuilder;
import com.suncode.pwfl.support.hibernate.type.StandardBasicTypes;
import com.suncode.pwfl.util.FinderFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DatabaseService {
    public static Logger log = Logger.getLogger(DatabaseService.class);
    private DatabaseExplorer databaseExplorer;
    private Database database;
    private String databaseSystemName;

    public DatabaseService(DatabaseExplorer dbExplorer, String databaseAlias) {
        this.databaseExplorer = dbExplorer;
        this.database = this.databaseExplorer.get(databaseAlias);
    }

    public DatabaseService(DatabaseExplorer dbExplorer) {
        this.databaseExplorer = dbExplorer;
    }

    public Database getDatabase() {
        return this.database;
    }

    private String lookingForDatabaseAlias() {
        log.debug((Object)"Looking DataBase Alias");
        List listAliasDB = this.databaseExplorer.getAliasService().getAliases();
        String catalogNameWithQuotes = null;
        String databaseAlias = null;
        for (Alias alias : listAliasDB) {
            catalogNameWithQuotes = "\"" + alias.getWrappedConnectionString().getCatalog() + "\"";
            if (!catalogNameWithQuotes.equals(this.databaseSystemName)) continue;
            databaseAlias = alias.getName();
            break;
        }
        log.debug((Object)("Found\t" + databaseAlias));
        return databaseAlias;
    }

    public String[] getQueryAndParameters(String queryName) {
        String[] result = new String[2];
        String tableQuery = "pm_querydatachooser";
        String queryRaw = null;
        String parametersRaw = null;
        try {
            SQLBuilder builder = new SQLBuilder();
            builder.setQuery("select query ,parameters from " + tableQuery + " where name=:key");
            builder.setParameter("key", (Object)queryName);
            builder.addScalar("query", StandardBasicTypes.STRING);
            builder.addScalar("parameters", StandardBasicTypes.STRING);
            List records = FinderFactory.getSQLFinder().find(builder);
            if (records != null && records.size() > 0) {
                queryRaw = (String)((Map)records.get(0)).get("query");
                parametersRaw = (String)((Map)records.get(0)).get("parameters");
            }
            result[0] = queryRaw;
            result[1] = parametersRaw;
        }
        catch (Exception e) {
            log.debug((Object)"Prawdopodobnie brak recordu w BD");
            log.debug((Object)e.getMessage());
            log.error((Object)e);
        }
        log.debug((Object)("Query: " + result[0]));
        log.debug((Object)("Parameteres: " + result[1]));
        return result;
    }

    public List<HashMap<String, String>> useQuery(String sqlQueryString) {
        log.debug((Object)"Use Query");
        ArrayList<HashMap<String, String>> results = new ArrayList<HashMap<String, String>>();
        this.database.schemaUpdated();
        DatabaseSession dbSession = this.database.openSession();
        try {
            PreparedStatement pstmQuery = dbSession.getConnection().prepareStatement(sqlQueryString);
            ResultSet rs = pstmQuery.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int numColumns = rsmd.getColumnCount();
            log.debug((Object)"create list of result data");
            while (rs.next()) {
                HashMap<String, String> oneRow = new HashMap<String, String>();
                for (int i = 1; i < numColumns + 1; ++i) {
                    String columnName = rsmd.getColumnName(i);
                    String oneValue = rs.getString(columnName);
                    columnName = columnName.toLowerCase();
                    log.debug((Object)("value: " + oneValue));
                    if (oneValue == null) {
                        oneValue = "";
                    }
                    oneRow.put(columnName, oneValue);
                }
                log.debug((Object)("row: " + oneRow.toString()));
                results.add(oneRow);
            }
            log.debug((Object)("Size data: " + results.size()));
            return results;
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
            log.error((Object)e);
            return null;
        }
    }
}

