/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.tools.autotask;

import com.suncode.plugin.tools.categories.Categories;
import com.suncode.pwfl.administration.user.UserService;
import com.suncode.pwfl.administration.user.UserSettingsService;
import com.suncode.pwfl.component.Category;
import com.suncode.pwfl.component.annotation.Define;
import com.suncode.pwfl.component.annotation.Param;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import com.suncode.pwfl.web.ui.Icon;
import com.suncode.pwfl.web.ui.SilkIconPack;
import com.suncode.pwfl.workflow.application.ApplicationDefinitionBuilder;
import com.suncode.pwfl.workflow.application.annotation.Application;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@Application
public class SetDashboardToDefaultView {
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private UserService userService;
    public static Logger log = Logger.getLogger(SetDashboardToDefaultView.class);
    private static String DEFAULT_VIEW_SET_DASHBOARD_VALUE = "com.suncode.plugin-dashboard:default-view";

    @Define
    public void definition(ApplicationDefinitionBuilder builder) {
        ((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)((ApplicationDefinitionBuilder)builder.id("tools.set-dashboard-to-default-view")).name("application.tools.set-dashboard-to-default-view.name")).description("application.tools.set-dashboard-to-default-view.desc")).category(new Category[]{Categories.TOOLS})).icon((Icon)SilkIconPack.LAYOUT_CONTENT)).parameter().id("logins").name("application.tools.set-dashboard-to-default-view.param.logins.name").type((Type)Types.STRING_ARRAY).create()).parameter().id("override-if-user-have-default-view").name("application.tools.set-dashboard-to-default-view.param.override-if-user-have-default-view.name").description("application.tools.set-dashboard-to-default-view.param.override-if-user-have-default-view.desc").type((Type)Types.BOOLEAN).defaultValue((Object)true).create();
    }

    public void execute(@Param(value="logins") String[] logins, @Param(value="override-if-user-have-default-view") Boolean overrideIfUserHaveDefaultView) {
        Arrays.stream(logins).forEach(login -> {
            if (overrideIfUserHaveDefaultView.booleanValue() || !this.userHaveDefaultView((String)login)) {
                this.setDashboardToDefaultView((String)login);
            } else {
                log.debug((Object)("Skip dashboard set to: " + login));
            }
        });
    }

    private boolean userHaveDefaultView(String login) {
        return this.userSettingsService.getSetting(login, UserSettingsService.UserSetting.DEFAULT_VIEW) != null;
    }

    private void setDashboardToDefaultView(String login) {
        if (this.userService.getUser(login, new String[0]) == null) {
            log.warn((Object)("Incorrect username: " + login));
        } else {
            this.userSettingsService.setUserSetting(login, UserSettingsService.UserSetting.DEFAULT_VIEW, DEFAULT_VIEW_SET_DASHBOARD_VALUE);
            log.debug((Object)("Dashboard has been set to: " + login));
        }
    }
}

