/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.spring.controller;

import com.google.gson.JsonObject;
import com.suncode.pwfl.administration.configuration.SystemProperties;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class GetData {
    public static Logger log = Logger.getLogger(GetData.class);
    private static String msSqlDataBaseUrl;
    private static String msSqlDataBaseName;
    private static String msSqlDataBasePort;
    private static long MILLIS_PER_DAY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getData(String nrFaktury, String kodDostawcy, String spolka) throws ServletException, IOException {
        Connection con = null;
        PrintWriter printWriter = null;
        JsonObject json = new JsonObject();
        try {
            log.debug((Object)("Pobranie linii faktur 'nrFaktury': " + nrFaktury + ", 'kodDostawcy': " + kodDostawcy + ", 'spolka': " + spolka));
            if (!nrFaktury.isEmpty() && !kodDostawcy.isEmpty()) {
                con = GetData.getConnectionWithAX();
                String query = "SELECT top 1 CONVERT(varchar, [DataFaktury], 23) as [DataFaktury], [KwotaNetto], [KwotaBrutto], CONVERT(varchar, [TerminPlatnosci], 23) as [TerminPlatnosci], [Waluta] FROM [dbo].[WfwVendEdiInv_Bon] WHERE [Firma] = ? AND [KodDostawcy] = ? AND [NrFaktury] = ?";
                PreparedStatement pstmt = con.prepareStatement(query);
                pstmt.setString(1, spolka);
                pstmt.setString(2, kodDostawcy);
                pstmt.setString(3, nrFaktury);
                ResultSet results = pstmt.executeQuery();
                if (results.next()) {
                    json.addProperty("Result", "Sukces");
                    json.addProperty("DataDokumentu", results.getString("DataFaktury") == null ? "" : results.getString("DataFaktury"));
                    json.addProperty("KwotaNetto", (Number)results.getDouble("KwotaNetto"));
                    json.addProperty("KwotaBrutto", (Number)results.getDouble("KwotaBrutto"));
                    json.addProperty("TerminPlatnosci", results.getString("TerminPlatnosci") == null ? "" : results.getString("TerminPlatnosci"));
                    json.addProperty("Waluta", results.getString("Waluta") == null ? "" : results.getString("Waluta"));
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    Date dInvDate = simpleDateFormat.parse(results.getString("DataFaktury") == null ? "" : results.getString("DataFaktury"));
                    Date dDueDate = simpleDateFormat.parse(results.getString("TerminPlatnosci") == null ? "" : results.getString("TerminPlatnosci"));
                    Long days = GetData.deltaDays(dDueDate, dInvDate);
                    json.addProperty("IloscDni", (Number)days);
                } else {
                    json.addProperty("Result", "Dane faktury nie zosta\u0142y znalezione.");
                }
            } else {
                json.addProperty("Result", "Wype\u0142nij najpierw pola Kod dostawcy i Nr faktury.");
                log.debug((Object)"Brak wype\u0142nionego numeru faktury lub kodu dostawcy lub sp\u00f3\u0142ki.");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
                if (printWriter != null) {
                    printWriter.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return json.toString();
    }

    private static Connection getConnectionWithAX() {
        return GetData.getJDBCConnectionWithAX("suncode_read", "suncode_read", msSqlDataBasePort, msSqlDataBaseName);
    }

    private static Connection getJDBCConnectionWithAX(String userID, String password, String port, String dataBaseName) {
        try {
            Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            if (DriverManager.getLoginTimeout() == 0) {
                DriverManager.setLoginTimeout(30);
            }
            log.debug((Object)String.format("Establishing connection (login timeout: %d)...", DriverManager.getLoginTimeout()));
            log.debug((Object)("URL: " + msSqlDataBaseUrl + " port: " + port));
            String connectionString = "jdbc:sqlserver://" + msSqlDataBaseUrl + ":" + port + ";database=" + dataBaseName + ";user=" + userID + ";password=" + password;
            Connection conn = DriverManager.getConnection(connectionString, userID, password);
            log.debug((Object)"Connected with AX!!!!!!!");
            return conn;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static List<Map<String, String>> execute(Connection con, String query) throws SQLException {
        Statement stmt = null;
        ResultSet rset = null;
        try {
            Date dtStart = new Date();
            log.debug((Object)("Wykonanie zapytania do MFG  :" + query));
            ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>();
            if (query.contains("INSERT") || query.contains("UPDATE")) {
                if (!con.isClosed()) {
                    stmt = con.createStatement();
                    stmt.executeUpdate(query);
                }
            } else {
                DatabaseMetaData metaData = con.getMetaData();
                if (metaData.supportsTransactionIsolationLevel(1)) {
                    con.setTransactionIsolation(1);
                }
                stmt = con.createStatement();
                rset = stmt.executeQuery(query);
                ResultSetMetaData rsmd = rset.getMetaData();
                int numColumns = rsmd.getColumnCount();
                while (rset.next()) {
                    HashMap<String, String> oneRow = new HashMap<String, String>();
                    for (int i = 1; i < numColumns + 1; ++i) {
                        String columnName = rsmd.getColumnName(i);
                        String value = rset.getString(columnName);
                        if (value == null) {
                            value = "";
                        }
                        oneRow.put(columnName, value);
                    }
                    results.add(oneRow);
                }
                log.debug((Object)("Ilosc zwroconych wynikow : " + results.size()));
            }
            Date dtEnd = new Date();
            log.debug((Object)("Przyblizony czas wykonania zapytania : " + (dtEnd.getTime() - dtStart.getTime())));
            ArrayList<Map<String, String>> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
    }

    private static long deltaDays(Date date1, Date date2) {
        long deltaMillis = date1.getTime() - date2.getTime();
        return deltaMillis / MILLIS_PER_DAY;
    }

    static {
        MILLIS_PER_DAY = 86400000L;
        try {
            msSqlDataBaseUrl = SystemProperties.getString((String)"MSSQLDATABASEURL");
            msSqlDataBaseName = SystemProperties.getString((String)"MSSQLDATABASE");
            msSqlDataBasePort = SystemProperties.getString((String)"MSSQLPORT");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

