/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.datasource.text.utils;

import com.suncode.plugin.datasource.text.enums.NewLineMode;
import com.suncode.plugin.datasource.text.enums.WriteMode;
import com.suncode.plugin.datasource.text.utils.BomUtils;
import com.suncode.plugin.datasource.text.utils.CharsetOption;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;

public class TextDataWriter {
    public static byte[] writeData(List<String> lines, CharsetOption charsetOption, NewLineMode newLineMode) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        String newLine = newLineMode != null ? newLineMode.getValue() : System.lineSeparator();
        Charset charset = charsetOption.getCharset();
        if (charsetOption.isWithBom()) {
            BomUtils.writeBom(byteArrayOutputStream, charset);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, charset);){
            TextDataWriter.writeLines(lines, writer, newLine);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeData(List<String> lines, String filePath, CharsetOption charsetOption, WriteMode writeMode, NewLineMode newLineMode) throws IOException {
        Path path = Paths.get(filePath, new String[0]);
        boolean append = WriteMode.APPEND.equals((Object)writeMode);
        String newLine = newLineMode != null ? newLineMode.getValue() : System.lineSeparator();
        Charset charset = charsetOption.getCharset();
        boolean writeBom = charsetOption.isWithBom();
        if (append) {
            TextDataWriter.handleNewLine(path, newLine, charset);
        }
        try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);){
            if (!append && writeBom && !BomUtils.fileHasBom(path, charset)) {
                BomUtils.writeBom(outputStream, charset);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset);){
                TextDataWriter.writeLines(lines, writer, newLine);
            }
        }
    }

    private static void writeLines(List<String> lines, Writer writer, String newLine) throws IOException {
        for (String line : lines) {
            writer.write(line);
            writer.write(newLine);
        }
    }

    private static void handleNewLine(Path path, String newLine, Charset charset) throws IOException {
        byte last;
        if (Files.exists(path, new LinkOption[0]) && Files.size(path) > 0L && (last = Files.readAllBytes(path)[(int)(Files.size(path) - 1L)]) != 10 && last != 13) {
            Files.write(path, newLine.getBytes(charset), StandardOpenOption.APPEND);
        }
    }

    private TextDataWriter() {
    }
}

